;  "Cosmic Raiders" #2019
;  For Bally Arcade/Astrocade
;
;  Designed and Programmed by Bob Ogdon
;  Audio by Scot L. Norris
;  Graphics by Julie Malan & Lisa Natting
;  Developed by Action Graphics
;
;
;  Version History:
;    .01 (Sept. 8, 2011) -  First Distributed version.
;                           VERY rough.  Only partially dissassembled.
;                           Graphics not yet found.  Mostly uncommented.
;                           Distributed to get some help/advice.
;    .02 (Sept. 10, 2011) - Still very rough, but much more of the code
;                           has been disassembled.  Many of the graphic
;                           patterns have been found.  Most code is still
;                           not commented.
;
;  Disassembly Started September 5, 2016 by AJT
;
;    v0.1 Continued on Sunday 10/7/2018 by Richard C. Degler
;
;
;  This program can be assembled using ZMAC.  Make sure that HVGLIB.H
;  is in the same directory and then type:
;      zmac -i -m -o cosmic.bin -x cosmic.lst cosmic.asm
;

        INCLUDE "HVGLIB.H"      ; Home Video Game Library

INTEN1  EQU     $4F11           ; Player 1 Intensity (0-9)
INTEN2  EQU     $4F12           ; Player 2 Intensity (0-9)
INTEN3  EQU     $4F13           ; Player 3 Intensity (0-9)
INTEN4  EQU     $4F14           ; Player 3 Intensity (0-9)
; NUMPLA  EQU     $4FF3         NOT Number of Players (use NUMPLY)
SHIPS   EQU     $4FF4           ; Number of SHIPS (NOT ENDSCR !!)
NOLINE  EQU     $60             ; Number Of LINEs = 96 (DISPLAYED for MENU only !!)

        ORG     FIRSTC

; L2000:
        JP      L3E72           ; Autostart "Cosmic Raiders"

        DB      $FF             ; 4-bytes filler
        DB      $FF
        DB      $FF
        DB      $FF

; L2007: or RVECT1 aka Reset VECTor #1
        JP      $FFFF           ; (not used)

; L200A: or RVECT2 (not used)
        JP      $0000           ; (not used)

; L200D: or RVECT3 (not used)
        JP      $0000           ; ditto

; L2010: or RVECT4 (not used)
        JP      $0000

; L2013: or RVECT5 (not used)
        JP      $0000

; L2016: or RVECT6 (not used)
        JP      $0000

; from L3E72: Start "Cosmic Raiders"
; not STVECT (SenTry VECTor if flagged)
L2019:  SYSSUK  FILL            ; UPI FILL memory with data
        DW      NORMEM          ; ... NORmal MEMory start
        DW      $0E80           ; ... Byte Count = 3712
        DB      $00             ; ... Data = 0 (into 92.8 pixel LINES)
        ;
        LD      (WASTE),A       ; flush the shifter !
        DEC     A               ; now 255 for 10.88 minutes before PIZBRK
        LD      (TIMOUT),A
        SYSTEM  EMUSIC          ; UPI End playing MUSIC (Zero out all 8 Sound ports !!)
        ;
        SYSSUK  SETOUT          ; UPI SET some OUTput ports
        DB      NOLINE*2 - 1    ; ... VERBL*2 = 191 ($BF) - Display 96 lines
        DB      $29             ; ... HORCB/4 = 41  (Horizontal Color Boundary)
        DB      $08             ; ... INMODE = 8, Light Pen interrupt DISABLE
                                ;                 and Screen interrupt ENABLE
        ;
        SYSSUK  COLSET          ; UPI COLors SET
        DW      $0013           ; ... On-Board ROM MENU COLORS table
        ;
        SYSTEM  ACTINT          ; UPI ACTivate sub timer INTerrupts
        ;
        RET

; Two's Complement HL value
L2035:  PUSH    DE
        LD      DE,$0000
        EX      DE,HL
        OR      A
        SBC     HL,DE
        POP     DE
        RET

; Look-up Handler for C/T No. in A
L203F:  LD      E,A
        LD      D,$00
        ADD     HL,DE           ; ALWAYS in $4FB2 + 2*A
        ADD     HL,DE
        LD      E,(HL)
        INC     HL
        LD      D,(HL)
        RET                     ; ... urn DE = C/T Handler address

; INTEGER divide HL by DE
; return Decimal Adjusted Accumulator in A
L2048:  ADD     A,C             ; half-carry + 1 or zero + 16
        DAA
        OR      A               ; set C flag
        SBC     HL,DE
        JR      NC,L2048        ; loop until too far
        ADD     HL,DE           ; restore one pass and ...
        SUB     C               ; back up 1 for right nybble or 16 for left nybble
        DAA
        RET

; with IY = $4FC5, H = 0, L = byte SCORE
; write 5-digit BCD number
L2053:  XOR     A
        LD      C,$01           ; right nybble
        LD      DE,$2710        ; 10000 digit
        CALL    L2048           ; divide
        LD      (IY+$02),A      ; write third BCD number
        XOR     A
        LD      C,$10           ; left nybble
        LD      DE,$03E8        ; 1000 digit
        CALL    L2048           ; divide
        LD      C,$01           ; right nybble
        LD      DE,$0064        ; 100 digit
        CALL    L2048           ; divide
        LD      (IY+$01),A      ; write second 2 BCD numbers
        XOR     A
        LD      C,$10           ; left nybble
        LD      DE,$000A        ; 10 digit
        CALL    L2048           ; divide
        ADD     A,L             ; right nybble
        LD      (IY+$00),A      ; write first 2 BCD numbers
        RET

; zero $4FB0 and $4FB1
L2081:  DI
        PUSH    AF
        XOR     A
        LD      ($4FB0),A
        INC     A
        LD      ($4FB1),A
        POP     AF
        EI
        RET

; zero $4FB1 and if $4FB0 not zero do read $4FAF and jump to it
L208E:  DI
        PUSH    AF
        PUSH    BC
        PUSH    DE
        PUSH    HL
        XOR     A
        LD      ($4FB1),A
        LD      HL,$4FB0
        OR      (HL)
        JR      NZ,L20A3
        POP     HL
        POP     DE
        POP     BC
        POP     AF
        EI
        RET

; (when $4FB0 not zero) zero it, then read $4FAF and ...
; jump to either ?? or Move Player's Ship ?? routines
L20A3:  EXX
        EX      AF,AF'
        PUSH    AF
        PUSH    BC
        PUSH    DE
        PUSH    HL
        PUSH    IY
        PUSH    IX
        LD      HL,($4FAF)
        XOR     A
        LD      ($4FB0),A
        JP      (HL)            ; to either L2360 or L34D4 for ??

; User MACRO routine 00 (or $80, or $81 since it always SUCKs All KEYs mask)
L20B5:  EXX
        LD      HL,L20C3        ; store for fake return from SENse TRansitionY
        PUSH    HL
        LD      HL,($010D)      ; SYSDPT + $42 for MENTRY shortcut to SENTRY:
        PUSH    HL
        EXX
        CALL    L2081           ; do Clear bytes $4FB0 and $4FB1
        RET                     ; ... urn to SENTRY

; on RETurn from fake CALL to SENTRY
L20C3:  CALL    L208E           ; do Clear byte $4FB1 and check $4FB0
        RET

; User UPI Routine tables
L20C7:  DW      L20B5           ; User MACRO routine 00 (Jump Address)
        ;
L20C9:  DB      00000011B       ; User Mask ARGument 00 = DE for ALKEYS mask
        ;
; L20CA: NOT used !!
        DB      $57             ; ?? LD  D,A ??

; for D = value to set into E = Counter Timer 0 through 7
L20CB:  DI
        LD      A,D
        LD      D,$00
        LD      HL,CT0          ; point at $4FD5
        ADD     HL,DE
        LD      (HL),A          ; preset C/T to value
        LD      HL,$4FB2        ; look-up Handler for C/T No. in E
        ADD     HL,DE           ; times 2
        ADD     HL,DE
        POP     DE              ; ?? store Return Address as Handler address ??
        LD      (HL),E
        INC     HL
        LD      (HL),D
        EI
        RET                     ; ?? up a level ??

; if ?? = 0 then Clear $4F9D through $4FAD and Silence SOUNDs, else clean-up
L20DF:  LD      HL,$4F9E        ; point at ??
        XOR     A
        CP      (HL)
        JR      Z,L20E8         ; if 0 then Clear $4F9D through $4FAD and Silence SOUNDs
        POP     HL              ; else clean-up
        RET

; clear $4F9D through $4FAD then Silence SOUNDs
L20E8:  LD      HL,$4F9D
        LD      BC,$0011        ; for 17 bytes
        XOR     A
L20EF:  LD      (HL),A          ; clear and loop until 0 found ??
        CPD                     ; Compare and Decrement
        JP      PE,L20EF        ; ?? or until BC OVerflows ??
        LD      BC,$0818        ; for 8 writes of 0 out ...
L20F8:  OUT     (C),A           ; ... port $18 SNDBX to Silence SOUNDs
        DJNZ    L20F8
        RET

; zero $4F9E ?? then ?? and on to ($4F9F)
L20FD:  LD      HL,$4F9E        ; point at ??
        LD      (HL),$00
        CALL    L20DF           ; if $4F9E = 0 then Clear $4F9D through $4FAD and Silence SOUNDs, else clean-up
        LD      HL,($4F9F)      ; read ?? L2994, L29C4, L298B
        LD      A,L
        OR      H
        JR      Z,L210D         ; if NOT an address, RETurn
        JP      (HL)            ; else JumP to it !!

L210D:  RET

; clear ?? address, then Zero $4F9E ?? then ?? and on to ($4F9F)
L210E:  LD      HL,$0000        ; write NOT an address
        LD      ($4F9F),HL
        JR      L20FD           ; zero $4F9E ?? then ?? and on to ($4F9F)

; write Return Address as ?? then to ??
L2116:  POP     HL              ; restore Return Address
        LD      ($4F9F),HL      ; write an address
        PUSH    HL              ; re-store Return Address
        JR      L20DF           ; if $4F9E = 0 then Clear $4F9D through $4FAD and Silence SOUNDs, else clean-up

; set $4F9E ?? to 1 for ??
L211D:  LD      HL,$4F9E
        LD      (HL),$01        ; write a 1 into ??
        RET

; With IY = $4F8D or $4F94 for various ?? 7-bytes of data in RAM for ??
L2123:  XOR     A
        CP      (IY+$04)
        JR      Z,L2174         ; if ?? to RET
        DEC     (IY+$04)
        JR      NZ,L2174        ; if ?? to RET
        LD      A,(IY+$05)
        LD      (IY+$04),A
        LD      A,(IY+$06)
        AND     $7F
        LD      C,A
        LD      A,(IY+$00)
        CP      (IY+$02)
        JR      C,L2169
        CP      (IY+$03)
        JR      NC,L2150
        ADD     A,(IY+$01)
L214A:  LD      (IY+$00),A
        OUT     (C),A
        RET

L2150:  BIT     7,(IY+$06)
        JR      NZ,L2162
L2156:  XOR     A
        SUB     (IY+$01)
        LD      (IY+$01),A
        ADD     A,(IY+$00)
        JR      L214A

L2162:  LD      A,(IY+$02)
        JR      L214A

; L2167:
        JR      L2174           ; ?? from where ?? to RET

L2169:  BIT     7,(IY+$06)
        JR      Z,L2156
        LD      A,(IY+$03)
        JR      L214A

L2174:  RET
; end of With IY = $4F8D or $4F94 for ??

L2175:  XOR     A
        LD      HL,$4F9D
        CP      (HL)
        RET     Z
        LD      HL,($4F9B)
        LD      A,L
        OR      H
        RET     Z
        DEC     HL
        LD      ($4F9B),HL
        LD      A,L
        OR      H
        JP      Z,L20FD         ; if ?? zero $4F9E ?? then ?? and on to ($4F9F)
        LD      IY,$4F8D
        CALL    L2123           ; else do With IY = $4F8D for ??
        LD      IY,$4F94
        JP      L2123           ; and do again With IY = $4F94 for ??

;  SENTRY RETURN Code SCT0 Handler
;  Counter-Timer 0 has counted down
L2198:  XOR     A
; multiple entry point with A = C/T number
L2199:  LD      HL,$4FB2
        CALL    L203F           ; look-it-up into DE
        LD      A,E
        OR      D
        JR      Z,L21A5         ; bail if NO address in RAM
        EX      DE,HL
        JP      (HL)            ; to adderess to Handle it !!

L21A5:  RET

;  SENTRY RETURN Code SCT1 Handler
;  Counter-Timer 1 has counted down
L21A6:  LD      A,$01
        JR      L2199

;  SENTRY RETURN Code SCT2 Handler
;  Counter-Timer 2 has counted down
L21AA:  LD      A,$02
        JR      L2199

;  SENTRY RETURN Code SCT3 Handler
;  Counter-Timer 3 has counted down
L21AE:  LD      A,$03
        JR      L2199

;  SENTRY RETURN Code SCT4 Handler
;  Counter-Timer 4 has counted down
L21B2:  LD      A,$04
        JR      L2199

;  SENTRY RETURN Code SCT5 Handler
;  Counter-Timer 5 has counted down
L21B6:  LD      A,$05
        JP      L2199

;  SENTRY RETURN Code SCT6 Handler
;  Counter-Timer 6 has counted down
L21BB:  LD      A,$06
        JP      L2199

;  SENTRY RETURN Code SCT7 Handler
;  Counter-Timer 7 has counted down
L21C0:  LD      A,$07
        JP      L2199

;  DOIT table
L21C5:  JMPd    SCT7,L21C0,0    ; JMP - $08 (SCT7), Counter-Timer 7 has counted down
        JMPd    SCT0,L2198,0    ; JMP - $01 (SCT0), Counter-Timer 0 has counted down
        JMPd    SCT1,L21A6,0    ; JMP - $02 (SCT1), Counter-Timer 1 has counted down
        JMPd    SCT2,L21AA,0    ; JMP - $03 (SCT2), Counter-Timer 2 has counted down
        JMPd    SCT3,L21AE,0    ; JMP - $04 (SCT3), Counter-Timer 3 has counted down
        JMPd    SCT4,L21B2,0    ; JMP - $05 (SCT4), Counter-Timer 4 has counted down
        JMPd    SCT5,L21B6,0    ; JMP - $06 (SCT5), Counter-Timer 5 has counted down
        JMPd    SCT6,L21BB,ENDx ; JMP - $07 (SCT6), Counter-Timer 6 has counted down

; load ($4F52 or $4F32) in HL + 4 into (HL) and (HL + 2) ??
L21DE:  PUSH    HL
        POP     DE
        INC     DE
        INC     DE
        INC     DE
        INC     DE
        LD      (HL),E
        INC     HL
        LD      (HL),D
        INC     HL
        LD      (HL),E
        INC     HL
        LD      (HL),D
        RET
; end of Load ($4F52 or $4F32) in HL + 4 into (HL) and (HL + 2) ??

; with HL = L2280 (Bottom half of Playfield) or with L227C (Top half) for ??
; with DE = $40E8 (Energy Star), $4145 (Even fighters), $41C1 (Odd fighters)
L21EC:  CALL    L2081           ; do Clear bytes $4FB0 and $4FB1
        PUSH    DE
        LD      E,(HL)          ; read First word of ?? table
        INC     HL
        LD      D,(HL)          ; store it ($4F52 or $4F32)
        PUSH    DE
        POP     IY              ; make Index Y point to it
        INC     HL
        LD      C,(IY+$00)      ; read first word in RAM (by $4F52 or $4F32 ??)
        LD      E,C
        LD      B,(IY+$01)
        LD      D,B
        LD      A,(HL)          ; read third byte of ?? table
        INC     HL
        CP      C               ; same as low byte in RAM word ?
        JR      NZ,L2206
        LD      A,(HL)          ; read forth byte of ?? table
        CP      B
L2206:  JR      NZ,L220D        ; same as high byte in RAM word ?
        PUSH    IY              ; yes, make BC point to second word in table
        POP     BC
        INC     BC
        INC     BC
L220D:  INC     BC              ; make BC point to second OR third word in TAM ??
        INC     BC
        LD      A,(IY+$02)      ; read second word in RAM
        CP      C
        LD      A,(IY+$03)
        JR      NZ,L2219
        CP      B               ; same as pointer ?
L2219:  JR      NZ,L2223
        POP     DE              ; yes, then eat ??
        LD      HL,$0001        ; and flag TERMINAL ERROR
        CALL    L208E           ; do Clear byte $4FB1 and check $4FB0
        RET                     ; ...urn HL = 1 for LOCK UP and die !!

; on second word in RAM is NOT same as pointer
L2223:  POP     HL
        LD      A,L             ; write ($4F52 or $4F32) as first word of RAM
        LD      (DE),A
        INC     DE
        LD      A,H
        LD      (DE),A
        LD      (IY+$00),C      ; write pointer as first word in RAM (that CAN't be right !!)
        LD      (IY+$01),B
        LD      HL,$0000
        CALL    L208E           ; do Clear byte $4FB1 and check $4FB0
        RET                     ; ...urn HL = 0 for NO error
; end of with HL = L2280 or with L227C for ??

; With HL = L227C OR L2280 for Top or Bottom half of Playfield ??
L2236:  CALL    L2081           ; do Clear bytes $4FB0 and $4FB1
        LD      E,(HL)          ; read First word of ?? table
        INC     HL
        LD      D,(HL)          ; store it ($4F52 or $4F32)
        PUSH    DE
        POP     IY              ; make Index Y point to it
        INC     HL
        LD      C,(IY+$02)      ; read second word in RAM (by table word + 2 ??)
        LD      B,(IY+$03)
        LD      A,(IY+$00)      ; read first word in RAM (by $4F52 or $4F32 ??)
        CP      C
        JR      NZ,L2250        ; same as second word in RAM ?
        LD      A,(IY+$01)
        CP      B
L2250:  JR      NZ,L2259        ; still the same ?
        LD      HL,$0001
        CALL    L208E           ; do Clear byte $4FB1 and check $4FB0
        RET                     ; ...urn HL = 1 for ??

; on first word in RAM is NOT same as second word in RAM
L2259:  LD      A,(BC)          ; load DE from second word in RAM
        LD      E,A
        INC     BC
        LD      A,(BC)
        LD      D,A
        DEC     BC
        LD      A,(HL)          ; read drom Second word of ?? table
        INC     HL
        CP      C               ; ComPare words
        JR      NZ,L2266
        LD      A,(HL)
        CP      B
L2266:  JR      NZ,L226D
        PUSH    IY
        POP     BC
        INC     BC
        INC     BC
L226D:  INC     BC              ; INCrement ??
        INC     BC
        LD      (IY+$02),C      ; and save ??
        LD      (IY+$03),B
        LD      HL,$0000
        CALL    L208E           ; do Clear byte $4FB1 and check $4FB0
        RET                     ; ...urn HL = 0 for ??
; end of With HL = L227C OR L2280 for ??

;  These next 8 bytes look like 2 tables of 2 RAM addresses to me ??
L227C:  DW      $4F52           ; lowest address of ?? 16-word table ??
        DW      $4F70           ; highest address of ?? is in Top half ??

L2280:  DW      $4F32           ; lowest address of ?? 16-word table ??
        DW      $4F50           ; highest address of ?? is in Bottom half ??

; does ??
L2284:  BIT     2,(IX+VBSTAT)   ; test UNKNOWN bit of Vector Block STATus ??
        RET     NZ
        SET     2,(IX+VBSTAT)   ; set UNKNOWN bit of Vector Block STATus for ??
        LD      A,($4F7A)       ; ?? always = 60 ??
        CP      (IX+VBYH)       ; CoMPare to Vector Block Y coord Hi
        JR      NC,L229E
        LD      HL,$4F75        ; is in Bottom half of Playfield
        INC     (HL)
        LD      HL,L2280        ; point at second table of 2 RAM addresses ??
        JR      L22A5

; is in Top half of Playfield
L229E:  LD      HL,$4F76
        INC     (HL)
        LD      HL,L227C        ; point at first table of 2 RAM addresses ??
L22A5:  PUSH    IX
        POP     DE
        CALL    L21EC           ; do ?? With HL = L2280 or L227C for ??
        LD      A,L
        OR      H
        JR      Z,L22B6         ; if ?? OK to exit
L22AF:  LD      A,R             ; !! locks-up while right third ...
        OUT     (COL0R),A       ; ... of Background FLASHes !!
        JP      L22AF           ; !! TERMINAL ERROR forever !!

; exit WITHOUT lockimg-up !!
L22B6:  RET
; end of ?? routine

; L22B7: NOT used ??
        POP     HL
        POP     DE
        PUSH    IY
        PUSH    BC
        CALL    L21EC           ; do ?? With HL = ?? for ??
        POP     BC
        POP     IY
        PUSH    HL
        JP      (IY)            ; to ??

; also NOT used ??
        POP     HL
        PUSH    IY
        PUSH    BC
        CALL    L2236           ; do With HL = ?? for ??
        POP     BC
        POP     IY
        LD      A,L
        OR      H
        JR      NZ,L22D4        ; skip if HL
        PUSH    DE
L22D4:  PUSH    HL
        JP      (IY)            ; to ??
; end of NOT used !!

; ?? with DE used for IX
L22D7:  PUSH    DE
        POP     IX
        RES     2,(IX+VBSTAT)   ; RESet UNKNOWN bit of Vector Block STATus for ??
        BIT     VBSACT,(IX+VBSTAT) ; test ACTive bit of Vector Block STATus
        RET     Z
        LD      A,($4FAE)
        LD      C,A
        SUB     (IX+$14)
        LD      B,(IX+$15)
        CP      B
        JR      C,L22F1
        LD      A,B
L22F1:  LD      C,(IX+$16)
        CP      C
        JP      C,L2321         ; if ?? to next routine to do ??
        LD      B,$00
L22FA:  SUB     C
        INC     B
        CP      C
        JP      NC,L22FA
        LD      C,A
        LD      A,($4FAE)
        SUB     C
        LD      (IX+$14),A
        LD      (IX+VBTIMB),B   ; write Vector Block TIMe Base ??
        LD      HL,L2321        ; point at next routine as ??
        PUSH    HL              ; ?? may be a fake Return Address ??
        LD      L,(IX+$0F)
        LD      H,(IX+$10)
        LD      DE,$0003
        ADD     HL,DE
        LD      E,(HL)
        INC     HL
        LD      D,(HL)
        EX      DE,HL
        CALL    L2081           ; do Clear bytes $4FB0 and $4FB1
        JP      (HL)            ; to ??

; next routine as ??
L2321:  CALL    L208E           ; do Clear byte $4FB1 and check $4FB0
        BIT     VBSACT,(IX+VBSTAT) ; test ACTive bit of Vector Block STATus
        CALL    NZ,L2284        ; if ?? do ??
        RET
; end of ?? with DE used for IX

; INITIAL Interrupt Routine !! INITIALizes ?? Vector poked into RAM at $4F86
; entry into Interrupt loop, or while running triggers at Scanline 112
L232C:  PUSH    AF              ; Store Environment
        PUSH    BC
        PUSH    DE
        PUSH    HL
        EXX
        EX      AF,AF'
        PUSH    AF
        PUSH    BC
        PUSH    DE
        PUSH    HL
        PUSH    IY
        PUSH    IX
        LD      A,($4F7D)       ; DIRT Interrupt Screen Line (always 147 ??)
        OUT     (INLIN),A       ; Port $0E, INterrupt LINe Register
        LD      A,$4F           ; High Order Byte Address of Interrupt Vector
        LD      I,A             ; Load Interrupt Vector Register
        LD      A,$8A           ; Get Low Order Byte Address
        OUT     (INFBK),A       ; Port $0D, INterrupt FeedBacK Register for $4F8A
        LD      HL,$4FAE
        INC     (HL)
        CALL    L2175
        LD      A,($4FB1)       ; check $4FB1
        OR      A
        JR      Z,L2360         ; if zero, next part of INITIAL Interrupt ...
        LD      DE,L2360        ; else save routine in $4FAF
        LD      HL,$4FAF
        LD      (HL),E
        INC     HL
        LD      (HL),D
        JP      L23B1           ; to Restore Environment

; next part of INITIAL Interrupt routine
L2360:  DI
        LD      BC,$0FFF
        LD      HL,$4FC2
        CALL    CTIMER          ; do Custom TIMERs
        LD      A,($4F79)
        CP      $00
        JP      NZ,L23B1        ; if NOT 0 then to Restore Environment
        LD      A,$01           ; else make it a 1
        LD      ($4F79),A
        XOR     A
        LD      ($4F72),A
        LD      A,($4F76)
        LD      ($4F74),A
        EI
L2382:  LD      A,($4F79)
        CP      $01
        JR      NZ,L23AC        ; if ?? do zero $4F79 then Restore Environment
        LD      A,($4F72)
        OR      A
        JR      NZ,L23AC        ; if ?? do zero $4F79 then Restore Environment
        LD      A,($4F74)
        OR      A
        JR      Z,L23AC         ; if ?? do zero $4F79 then Restore Environment
        LD      HL,L227C        ; point at first table of 2 RAM addresses ??
        CALL    L2236           ; do With HL = L227C for ??
        LD      A,L
        OR      H
        JR      NZ,L23AC        ; if HL then do zero $4F79 and Restore Environment
        LD      HL,$4F76        ; else ??
        DEC     (HL)
        LD      HL,$4F74
        DEC     (HL)
        CALL    L22D7           ; do ?? with DE used for IX
        JR      L2382           ; loop for next ??

; last of INITIAL Interrupt routine
L23AC:  LD      A,$00
        LD      ($4F79),A       ; zero $4F79 then ...
L23B1:  POP     IX              ; Retore Environment
        POP     IY
        POP     HL
        POP     DE
        POP     BC
        POP     AF
        EX      AF,AF'
        EXX
        POP     HL
        POP     DE
        POP     BC
        POP     AF
        EI
        RET
; end of INITIAL Interrupt routine

; initialize some Interrupt stuff then run INITIAL Interrupt Routine
L23C1:  DI                      ; DISable INTERRUPT Looping until INITIALized !!
        LD      A,$08           ; for Screen Ints. only !!
        OUT     (INMOD),A       ; Port $0E (NOT $0F!!), INterrupt MODe Register
        IM      2               ; Set Interrupt Mode 2 Condition
        CALL    L232C           ; do INITIAL Interrupt Routine above (to begin looping)
        DI                      ; re-DISable INTERRUPT Looping to begin quite yet !!
        RET

; STARTING Interrupt Routine ?? Vector poked into RAM at $4F7E
; does ?? (Still Playfield Colors ??) triggered at Scanline 108
L23CD:  PUSH    AF
        LD      A,($4F7B)       ; read INITIAL INterrupt screen LINe (always = 112 ??)
        OUT     (INLIN),A
        LD      A,$4F
        LD      I,A
        LD      A,$86
        OUT     (INFBK),A       ; set INterrupt FeedBacK for $4F86 in RAM
        LD      A,($4F78)
        CP      $01
        JR      NZ,L23E7        ; if ?? = 1 make it a 2
        LD      A,$02
        LD      ($4F78),A
L23E7:  POP     AF
        EI
        RET

; convert XY RELative to ABSolute address
; with A = MAGIC to set, D = X, H = Y
; RETurn with with A = MAGIC, HL = Address
L23EA:  AND     $FC             ; toss out shift amount
        LD      B,A             ; keep top 6 bits
        LD      A,D             ; get X
        LD      C,A             ; save
        LD      L,H             ; HL = Y
        LD      H,$00
        ADD     HL,HL           ; times 8
        ADD     HL,HL
        ADD     HL,HL
        LD      D,H             ; save Y * 8
        LD      E,L
        ADD     HL,HL           ; now times 32
        ADD     HL,HL
        ADD     HL,DE           ; plus times 8 for Y times BYTEPL
        SRL     A               ; divide X by 4
        SRL     A
        LD      E,A             ; as X bytes
        LD      D,$00
        ADD     HL,DE           ; HL = Y * 40 + X divided by 4
        LD      A,C             ; un-save X
        AND     MRSHFT          ; mask with $03
        BIT     MRFLOP,B        ; is bit 6 set?
        JR      Z,L240E         ; jump if not
        NEG                     ; yep - flop the SHIFT amount !!
        JR      NZ,L240E        ; SHIFT was NOT 3, so now it's NOT 0 ?
        DEC     HL              ; else now 0, so move X left 4 whole pixels
L240E:  AND     MRSHFT          ; mask with $03 again
        OR      B               ; combine with MR
        RET
; note: unlike SYSTEM RELABS,  only the SHIFT amount FLOPs, not the X coordinate system !!

; draw Pattern to Absolute Magic Address START location
; with A = MAGIC register value, with proper shift amount set
; and BC = Pattern Start, DE = Pattern Sizes, and HL = Magic Address
L2412:  OUT     (MAGIC),A       ; write MAGIC register
        BIT     MRFLOP,A        ; test bit 6 for FLOP ?
        JR      Z,L242D
L2418:  PUSH    DE              ; store Pattern Sizes
        PUSH    HL              ; store Magic Address
L241A:  LD      A,(BC)          ; read Pattern Data byte
        LD      (HL),A          ; write to Magic Address
        DEC     HL              ; Destination minus 1
        INC     BC              ; Source plus 1
        DEC     E               ; Bytes minus 1
        JR      NZ,L241A        ; to Inner loop
        LD      (HL),E          ; write a 0 to finalize
        POP     HL              ; restore to Right byte of Row
        LD      DE,$0028        ; 40 for BYTEPL
        ADD     HL,DE           ; drop to Next Row
        POP     DE              ; restore Pattern Sizes
        DEC     D               ; Height minus 1
        JR      NZ,L2418        ; to Outer loop
        JR      L2440           ; to read INTercept STatus

; on NO FLOP
L242D:  PUSH    DE              ; store Pattern Sizes
        PUSH    HL              ; store Magic Address
L242F:  LD      A,(BC)          ; read Pattern Data byte
        LD      (HL),A          ; write to Magic Address
        INC     HL              ; Destination plus 1
        INC     BC              ; Source plus 1
        DEC     E               ; Bytes minus 1
        JR      NZ,L242F        ; to Inner loop
        LD      (HL),E          ; write a 0 to finalize
        POP     HL              ; restore to Left byte of Row
        LD      DE,$0028        ; 40 for BYTEPL
        ADD     HL,DE           ; drop to Next Row
        POP     DE              ; restore Pattern Sizes
        DEC     D               ; Height minus 1
        JR      NZ,L242D        ; to Outer loop
L2440:  IN      A,(INTST)       ; read port $08 for INTercept STatus
        RET

; draw a Pattern using IX Block information
L2443:  LD      L,(IX+$11)      ; read Pattern Base address
        LD      H,(IX+$12)
        INC     HL              ; skip XY Displacement
        INC     HL
        LD      E,(HL)          ; read DE Pattern Sizes
        INC     HL
        LD      D,(HL)
        INC     HL
        LD      B,H             ; save Pattern Upper Left address in BC
        LD      C,L
        LD      L,(IX+VBOAL)    ; read HL OLD Absolute Magic Address
        LD      H,(IX+VBOAH)
        IN      A,(INTST)       ; read port $08 to RESET INTercept STatus
        LD      A,(IX+VBMR)     ; read MAGIC value, with proper shift amount set
        CALL    L2412           ; draw Pattern to Magic location
        RET

; ??
L2460:  LD      L,(IX+$11)      ; read Pattern Base address
        LD      H,(IX+$12)
        LD      C,(IX+VBMR)     ; read MAGIC to use
        LD      A,(IX+VBXH)     ; read X location to use
        BIT     MRFLOP,C        ; test Magic Register bit 6 for FLOP ?
        JR      Z,L2473
        ADD     A,(HL)
        JR      L2474

; on NO bit 6 ?? so no FLOP
L2473:  SUB     (HL)
L2474:  INC     HL
        LD      D,A
        LD      A,(IX+VBYH)     ; read Y location to use
        SUB     (HL)
        INC     HL
        PUSH    HL
        LD      H,A
        IN      A,(INTST)       ; read port $08 to RESET INTercept STatus
        LD      A,C
        CALL    L23EA           ; convert XY RELative to ABSolute address
        LD      (IX+VBMR),A     ; write MAGIC value, with proper shift amount set
        EX      (SP),HL
        LD      E,(HL)          ; read DE Pattern Sizes
        INC     HL
        LD      D,(HL)
        INC     HL
        LD      B,H             ; save Pattern Upper Left address in BC
        LD      C,L
        POP     HL
        LD      (IX+VBOAH),H    ; write HL OLD Absolute Magic Address
        LD      (IX+VBOAL),L
        JP      L2412           ; to draw Pattern to Magic location

; does Write 1 byte to Magic RAM with extra write for SHIFT and check for COLLISION
L2497:  LD      A,(IX+VBMR)     ; read Vector Block Magic Register
        LD      H,(IX+VBYH)     ; read Vector Block Y coord Hi
        LD      D,(IX+VBXH)     ; read Vector Block X coord Hi
        LD      A,(IX+VBMR)     ; read Vector Block Magic Register AGAIN ??
        CALL    L23EA           ; convert XY RELative to ABSolute address
        LD      (IX+VBOAH),H    ; write Vector Block Old Address Hi
        LD      (IX+VBOAL),L    ; write Vector Block Old Address Low
        LD      (IX+VBMR),A     ; write Vector Block Magic Register (with SHIFT)
L24AF:  OUT     (MAGIC),A       ; write MAGIC register
        IN      A,(INTST)       ; read port $08 to RESET INTercept STatus
        LD      A,(IX+VBSTAT)   ; read Vector Block STATus byte
        LD      (HL),A          ; write Vector Block STATus byte to SCREEN
        XOR     A
        INC     HL
        LD      (HL),A          ; write a 0e to SCREEN + 1
        IN      A,(INTST)       ; read port $08 for INTercept STatus
        RET

; does Erase 1 byte from Magic RAM with extra write for SHIFT and check for COLLISION
L24BD:  LD      L,(IX+VBOAL)    ; read Vector Block Old Address Low
        LD      H,(IX+VBOAH)    ; read Vector Block Old Address Hi
        LD      A,(IX+VBMR)     ; read Vector Block Magic Register (with SHIFT)
        JR      L24AF

;  Pattern  - Bomb (Frame 1)
;  Colors   - . = Black     2 = Yellow
;             1 = Blue      3 = Red
L24C8:  DB      $04, $05        ; X,Y Displacement
        DB      $03, $09        ; X,Y Size
        DB      $C0,$00,$C0     ; 3 . . . . . . . 3 . . .
        DB      $00,$00,$00     ; . . . . . . . . . . . .
        DB      $04,$04,$00     ; . . 1 . . . 1 . . . . .
        DB      $01,$90,$00     ; . . . 1 2 1 . . . . . .
        DB      $03,$30,$00     ; . . . 3 . 3 . . . . . .
        DB      $04,$04,$00     ; . . 1 . . . 1 . . . . .
        DB      $02,$20,$00     ; . . . 2 . 2 . . . . . .
        DB      $01,$90,$00     ; . . . 1 2 1 . . . . . .
        DB      $00,$C0,$00     ; . . . . 3 . . . . . . .

;  Pattern  - Bomb (Frame 2)
L24E7:  DB      $03,04          ; X,Y Displacement
        DB      $02,$08         ; X,Y Size
        DB      $41,$04         ; 1 . . 1 . . 1 .
        DB      $32,$30         ; . 3 . 2 . 3 . .
        DB      $08,$80         ; . . 2 . 2 . . .
        DB      $31,$30         ; . 3 . 1 . 3 . .
        DB      $05,$40         ; . . 1 1 1 . . .
        DB      $01,$00         ; . . . 1 . . . .
        DB      $0B,$80         ; . . 2 3 2 . . .
        DB      $02,$00         ; . . . 2 . . . .

; Animation table for 2 Bombs
L24FB:  DB      $03             ; Duration byte first, then word ...
        DW      L24C8           ; Pattern  Address - Bomb #1
        DB      $03             ; Duration ...
        DW      L24E7           ; Pattern  Address - Bomb #2
        DB      $00             ; NO Duration, then Loop back to label ...
        DW      L24FB           ; loop to Start of Bomb Animation Table

;  Pattern  - Bomb-Explosion (Frame 1)
L2504:  DB      $03,$03         ; X,Y Displacement
        DB      $02,$06         ; X,Y Size
        DB      $10,$00         ; . 1 . . . . . .
        DB      $21,$24         ; . 2 . 1 . 2 1 .
        DB      $00,$10         ; . . . . . 1 . .
        DB      $40,$00         ; 1 . . . . . . .
        DB      $90,$34         ; 2 1 . . . 3 1 .
        DB      $C1,$04         ; 3 . . 1 . . 1 .

;  Pattern  - Bomb-Explosion (Frame 2)
L2514:  DB      $05,$04         ; X,Y Displacement
        DB      $03,$09         ; X,Y Size
        DB      $00,$20,$00     ; . . . . . 2 . . . . . .
        DB      $10,$00,$90     ; . 1 . . . . . . 2 1 . .
        DB      $20,$10,$40     ; . 2 . . . 1 . . 1 . . .
        DB      $00,$00,$00     ; . . . . . . . . . . . .
        DB      $00,$00,$30     ; . . . . . . . . . 3 . .
        DB      $40,$00,$00     ; 1 . . . . . . . . . . .
        DB      $90,$00,$00     ; 2 1 . . . . . . . . . .
        DB      $C0,$00,$D0     ; 3 . . . . . . . 3 1 . .
        DB      $00,$30,$10     ; . . . . . 3 . . . 1 . .

; Animation table for 2 Bomb-Explosions (used for Energy Stars ??)
L2533:  DB      $14
        DW      L2504           ; Pattern Address Bomb-Explosion #1
        DB      $FE
        DW      L2514           ; Pattern Address Bomb-Explosion #2
        DB      $00
        DW      L2533           ; loop to Start of Bomb-Explosion Animation Table

;  Pattern  - Energy Star (Frame 1)
L253C:  DB      $04,$03         ; X,Y Displacement
        DB      $03,$08         ; X,Y Size
        DB      $00,$40,$00     ; . . . . 1 . . . . . . .
        DB      $01,$10,$00     ; . . . 1 . 1 . . . . . .
        DB      $54,$05,$40     ; 1 1 1 . . . 1 1 1 . . .
        DB      $10,$C1,$00     ; . 1 . . 3 . . 1 . . . .
        DB      $04,$04,$00     ; . . 1 . . . 1 . . . . .
        DB      $01,$10,$00     ; . . . 1 . 1 . . . . . .
        DB      $01,$10,$00     ; . . . 1 . 1 . . . . . .
        DB      $00,$40,$00     ; . . . . 1 . . . . . . .

;  Pattern  - Energy Star (Frame 2)
L2558:  DB      $04,$03         ; X,Y Displacement
        DB      $03,$08         ; X,Y Size
        DB      $00,$C0,$00     ; . . . . 3 . . . . . . .
        DB      $03,$30,$00     ; . . . 3 . 3 . . . . . .
        DB      $FC,$0F,$C0     ; 3 3 3 . . . 3 3 3 . . .
        DB      $30,$C3,$00     ; . 3 . . 3 . . 3 . . . .
        DB      $0C,$0C,$00     ; . . 3 . . . 3 . . . . .
        DB      $03,$30,$00     ; . . . 3 . 3 . . . . . .
        DB      $03,$30,$00     ; . . . 3 . 3 . . . . . .
        DB      $00,$C0,$00     ; . . . . 3 . . . . . . .

;  Pattern  - Energy Star (Frame 3)
L2574:  DB      $04,$03         ; X,Y Displacement
        DB      $03,$08         ; X,Y Size
        DB      $00,$80,$00     ; . . . . 2 . . . . . . .
        DB      $02,$20,$00     ; . . . 2 . 2 . . . . . .
        DB      $A8,$0A,$80     ; 2 2 2 . . . 2 2 2 . . .
        DB      $20,$42,$00     ; . 2 . . 1 . . 2 . . . .
        DB      $08,$08,$00     ; . . 2 . . . 2 . . . . .
        DB      $02,$20,$00     ; . . . 2 . 2 . . . . . .
        DB      $02,$20,$00     ; . . . 2 . 2 . . . . . .
        DB      $00,$80,$00     ; . . . . 2 . . . . . . .

; Animation table for 3 Energy Stars
L2590:  DB      $04
        DW      L253C           ; Pattern Address Energy Star #1
        DB      $04
        DW      L2558           ; Pattern Address Energy Star #2
        DB      $04
        DW      L2574           ; Pattern Address Energy Star #3
        DB      $00
        DW      L2590           ; loop to Start of Energy Stars Animation Table

;  Pattern  - TYPE-1 Fighter (Frame 1)
; aka Diamond-wing Bat/Bird
L259C:  DB      $05,$03         ; X,Y Displacement
        DB      $03,$07         ; X,Y Size
        DB      $00,$A0,$00     ; . . . . 2 2 . . . . . .
        DB      $0A,$0A,$00     ; . . 2 2 . . 2 2 . . . .
        DB      $A0,$00,$A0     ; 2 2 . . . . . . 2 2 . .
        DB      $00,$50,$00     ; . . . . 1 1 . . . . . .
        DB      $A0,$00,$A0     ; 2 2 . . . . . . 2 2 . .
        DB      $0A,$0A,$00     ; . . 2 2 . . 2 2 . . . .
        DB      $00,$A0,$00     ; . . . . 2 2 . . . . . .

;  Pattern  - TYPE-1 Fighter (Frame 2)
L25B5:  DB      $05,$01         ; X,Y Displacement
        DB      $03,$03         ; X,Y Size
        DB      $00,$00,$00     ; . . . . . . . . . . . .
        DB      $55,$55,$50     ; 1 1 1 1 1 1 1 1 1 1 . .
        DB      $00,$00,$00     ; . . . . . . . . . . . .

; Animation table for 2 TYPE-1 Fighters
L25C2:  DB      $03
        DW      L259C           ; Pattern Address TYPE-1 Fighter #1
        DB      $03
        DW      L25B5           ; Pattern Address TYPE-1 Fighter #2
        DB      $00
        DW      L25C2           ; loop to Start of TYPE-1 Fighters Animation Table

;  Pattern  - TYPE-2 Fighter
; aka STEADY-on NO Exhaust
L25CB:  DB      $05,$03         ; X,Y Displacement
        DB      $02,$07         ; X,Y Size
        DB      $00,$05         ; . . . . . . 1 1
        DB      $00,$24         ; . . . . . 2 1 .
        DB      $00,$50         ; . . . . 1 1 . .
        DB      $51,$11         ; 1 1 . 1 . 1 . 1
        DB      $00,$50         ; . . . . 1 1 . .
        DB      $00,$24         ; . . . . . 2 1 .
        DB      $00,$05         ; . . . . . . 1 1

; Animation table for 1 TYPE-2 Fighter
L25DD:  DB      $FF             ; l-o-o-o-n-g Duration !!
        DW      L25CB           ; Pattern Address TYPE-2 Fighter #1
        DB      $00
        DW      L25DD           ; loop to Start of TYPE-2 Fighter Animation Table

;  Pattern  - TYPE-3 Fighter (Frame 1)
; aka Flying Bricks
L25E3:  DB      $05,$02         ; X,Y Displacement
        DB      $03,$05         ; X,Y Size
        DB      $15,$57,$C0     ; . 1 1 1 1 1 1 3 3 . . .
        DB      $04,$00,$40     ; . . 1 . . . . . 1 . . .
        DB      $D5,$55,$50     ; 3 1 1 1 1 1 1 1 1 1 . .
        DB      $01,$04,$04     ; . . . 1 . . 1 . . . 1 .
        DB      $00,$55,$5F     ; . . . . 1 1 1 1 1 1 3 3

;  Pattern  - TYPE-3 Fighter (Frame 2)
L25F6:  DB      $05,$02         ; X,Y Displacement
        DB      $03,$04         ; X,Y Size
        DB      $55,$5F,$00     ; 1 1 1 1 1 1 3 3 . . . .
        DB      $10,$40,$40     ; . 1 . . 1 . . . 1 . . .
        DB      $D5,$55,$50     ; 3 1 1 1 1 1 1 1 1 1 . .
        DB      $00,$00,$00     ; . . . . . . . . . . . .

;  Pattern  - TYPE-3 Fighter (Frame 3)
L2606:  DB      $05,$00         ; X,Y Displacement
        DB      $03,$03         ; X,Y Size
        DB      $D5,$55,$50     ; 3 1 1 1 1 1 1 1 1 1 . .
        DB      $04,$04,$04     ; . . 1 . . . 1 . . . 1 .
        DB      $01,$55,$5F     ; . . . 1 1 1 1 1 1 1 3 3

; Animation table for 3 TYPE-3 Fighters
L2613:  DB      $02
        DW      L25E3           ; Pattern Address TYPE-3 Fighter #1
        DB      $02
        DW      L25F6           ; Pattern Address TYPE-3 Fighter #2
        DB      $02
        DW      L2606           ; Pattern Address TYPE-3 Fighter #3
        DB      $00
        DW      L2613           ; loop to Start of TYPE-3 Fighter Animation Table

;  Pattern  - TYPE-4 Fighter (Frame 1)
; aka PULSATING Exhaust
L261F:  DB      $05,$04         ; X,Y Displacement
        DB      $03,$09         ; X,Y Size
        DB      $00,$15,$40     ; . . . . . 1 1 1 1 . . .
        DB      $00,$04,$00     ; . . . . . . 1 . . . . .
        DB      $00,$54,$00     ; . . . . 1 1 1 . . . . .
        DB      $05,$03,$00     ; . . 1 1 . . . 3 . . . .
        DB      $56,$A8,$00     ; 1 1 1 2 2 2 2 . . . . .
        DB      $05,$03,$00     ; . . 1 1 . . . 3 . . . .
        DB      $00,$54,$00     ; . . . . 1 1 1 . . . . .
        DB      $00,$04,$00     ; . . . . . . 1 . . . . .
        DB      $00,$15,$40     ; . . . . . 1 1 1 1 . . .

;  Pattern  - TYPE-4 Fighter (Frame 2)
L263E:  DB      $05,$04         ; X,Y Displacement
        DB      $03,$09         ; X,Y Size
        DB      $00,$15,$40     ; . . . . . 1 1 1 1 . . .
        DB      $00,$04,$00     ; . . . . . . 1 . . . . .
        DB      $00,$54,$00     ; . . . . 1 1 1 . . . . .
        DB      $05,$03,$50     ; . . 1 1 . . . 3 1 1 . .
        DB      $56,$A8,$00     ; 1 1 1 2 2 2 2 . . . . .
        DB      $05,$03,$50     ; . . 1 1 . . . 3 1 1 . .
        DB      $00,$54,$00     ; . . . . 1 1 1 . . . . .
        DB      $00,$04,$00     ; . . . . . . 1 . . . . .
        DB      $00,$15,$40     ; . . . . . 1 1 1 1 . . .

;  Pattern  - TYPE-4 Fighter (Frame 3)
L265D:  DB      $05,$04         ; X,Y Displacement
        DB      $03,$09         ; X,Y Size
        DB      $00,$15,$40     ; . . . . . 1 1 1 1 . . .
        DB      $00,$04,$00     ; . . . . . . 1 . . . . .
        DB      $00,$54,$00     ; . . . . 1 1 1 . . . . .
        DB      $05,$01,$D0     ; . . 1 1 . . . 1 3 1 . .
        DB      $56,$A8,$00     ; 1 1 1 2 2 2 2 . . . . .
        DB      $05,$01,$D0     ; . . 1 1 . . . 1 3 1 . .
        DB      $00,$54,$00     ; . . . . 1 1 1 . . . . .
        DB      $00,$04,$00     ; . . . . . . 1 . . . . .
        DB      $00,$15,$40     ; . . . . . 1 1 1 1 . . .

; Animation table for 3 TYPE-4 Fighters
L267C:  DB      $02
        DW      L261F           ; Pattern Address TYPE-4 Fighter #1
        DB      $02
        DW      L263E           ; Pattern Address TYPE-4 Fighter #2
        DB      $02
        DW      L265D           ; Pattern Address TYPE-4 Fighter #3
        DB      $00
        DW      L267C           ; loop to Start of TYPE-4 Fighter Animation Table

;  Pattern  - Ship-Explosion (Frame 1)
L2688:  DB      $04,$05         ; X,Y Displacement
        DB      $02,$08         ; X,Y Size
        DB      $00,$C0         ; . . . . 3 . . .
        DB      $01,$00         ; . . . 1 . . . .
        DB      $04,$90         ; . . 1 . 2 1 . .
        DB      $C9,$43         ; 3 . 2 1 1 . . 3
        DB      $11,$64         ; . 1 . 1 1 2 1 .
        DB      $06,$10         ; . . 1 2 . 1 . .
        DB      $00,$40         ; . . . . 1 . . .
        DB      $03,$00         ; . . . 3 . . . .

;  Pattern  - Ship-Explosion (Frame 2)
L269C:  DB      $05,$05         ; X,Y Displacement
        DB      $03,$08         ; X,Y Size
        DB      $20,$30,$80     ; . 2 . . . 3 . . 2 . . .
        DB      $04,$41,$00     ; . . 1 . 1 . . 1 . . . .
        DB      $01,$24,$00     ; . . . 1 . 2 1 . . . . .
        DB      $32,$50,$C0     ; . 3 . 2 1 1 . . 3 . . .
        DB      $04,$59,$00     ; . . 1 . 1 1 2 1 . . . .
        DB      $11,$84,$00     ; . 1 . 1 2 . 1 . . . . .
        DB      $80,$11,$00     ; 2 . . . . 1 . 1 . . . .
        DB      $00,$C0,$80     ; . . . . 3 . . . 2 . . .

;  Pattern  - Ship-Explosion (Frame 3)
L26B8:  DB      $06,$07         ; X,Y Displacement
        DB      $03,$0B         ; X,Y Size
        DB      $C0,$03,$00     ; 3 . . . . . . 3 . . . .
        DB      $13,$20,$4C     ; . 1 . 3 . 2 . . 1 . 3 .
        DB      $08,$0C,$20     ; . . 2 . . . 3 . . 2 . .
        DB      $01,$10,$43     ; . . . 1 . 1 . . 1 . . 3
        DB      $10,$49,$04     ; . 1 . . 1 . 2 1 . . 1 .
        DB      $CC,$94,$30     ; 3 . 3 . 2 1 1 . . 3 . .
        DB      $21,$16,$48     ; . 2 . 1 . 1 1 2 1 . 2 .
        DB      $04,$61,$03     ; . . 1 . 1 2 . 1 . . . 3
        DB      $20,$04,$44     ; . 2 . . . . 1 . 1 . 1 .
        DB      $C4,$30,$20     ; 3 . 1 . . 3 . . . 2 . .
        DB      $03,$08,$CC     ; . . . 3 . . 2 . 3 . 3 .

;  Pattern  - Ship-Explosion (Frame 4)
L26DD:  DB      $09,$09         ; X,Y Displacement
        DB      $05,$10         ; X,Y Size
        DB  $00,$01,$0C,$40,$00 ; . . . . . . . 1 . . 3 . 1 . . . . . . .
        DB  $00,$48,$10,$20,$00 ; . . . . 1 . 2 . . 1 . . . 2 . . . . . .
        DB  $43,$01,$0C,$04,$00 ; 1 . . 3 . . . 1 . . 3 . . . 1 . . . . .
        DB  $04,$4C,$81,$30,$00 ; . . 1 . 1 . 3 . 2 . . 1 . 3 . . . . . .
        DB  $00,$20,$30,$01,$00 ; . . . . . 2 . . . 3 . . . . . 1 . . . .
        DB  $33,$04,$41,$0C,$00 ; . 3 . 3 . . 1 . 1 . . 1 . . 3 . . . . .
        DB  $08,$40,$20,$10,$00 ; . . 2 . 1 . . . . 2 . . . 1 . . . . . .
        DB  $03,$30,$00,$C0,$80 ; . . . 3 . 3 . . . . . . 3 . . . 2 . . .
        DB  $04,$00,$00,$21,$00 ; . . 1 . . . . . . . . . . 2 . 1 . . . .
        DB  $00,$10,$80,$0C,$00 ; . . . . . 1 . . 2 . . . . . 3 . . . . .
        DB  $44,$80,$01,$11,$00 ; 1 . 1 . 2 . . . . . . 1 . 1 . 1 . . . .
        DB  $03,$00,$C0,$80,$00 ; . . . 3 . . . . 3 . . . 2 . . . . . . .
        DB  $04,$0C,$23,$30,$00 ; . . 1 . . . 3 . . 2 . 3 . 3 . . . . . .
        DB  $00,$10,$40,$40,$40 ; . . . . . 1 . . 1 . . . 1 . . . 1 . . .
        DB  $04,$08,$02,$10,$00 ; . . 1 . . . 2 . . . . 2 . 1 . . . . . .
        DB  $00,$41,$04,$01,$00 ; . . . . 1 . . 1 . . 1 . . . . 1 . . . .

; Animation table for 4 Ship-Explosions
L2731:  DB      $03
        DW      L2688           ; Pattern Address Ship-Explosion #1
        DB      $03
        DW      L269C           ; Pattern Address Ship-Explosion #2
        DB      $03
        DW      L26B8           ; Pattern Address Ship-Explosion #3
        DB      $FF
        DW      L26DD           ; Pattern Address Ship-Explosion #4
        DB      $00
        DW      L2731           ; loop to Start of Ship-Explosion Animation Table

;  Pattern  - Player's Ship (plain)
;  Colors   - . = Black     2 = Yellow
;             1 = Blue      3 = Red
L2740:  DB      $05, $01        ; X,Y Displacement
        DB      $03, $04        ; X,Y Size
        DB      $28,$00,$00     ; . 2 2 . . . . . . . . .
        DB      $2A,$FF,$40     ; . 2 2 2 3 3 3 3 1 . . .
        DB      $AA,$AA,$A0     ; 2 2 2 2 2 2 2 2 2 2 . .
        DB      $22,$00,$00     ; . 2 . 2 . . . . . . . .

;  Pattern  - Player's Ship (With Rocket Exhaust, Frame 1)
L2750:  DB      $0D,$01         ; X,Y Displacement
        DB      $05,$04         ; X,Y Size
        DB  $00,$40,$28,$00,$00 ; . . . . 1 . . . . 2 2 . . . . . . . . .
        DB  $13,$0C,$2A,$FF,$40 ; . 1 . 3 . . 3 . . 2 2 2 3 3 3 3 1 . . .
        DB  $30,$13,$AA,$AA,$A0 ; . 3 . . . 1 . 3 2 2 2 2 2 2 2 2 2 2 . .
        DB  $41,$0C,$22,$00,$00 ; 1 . . 1 . . 3 . . 2 . 2 . . . . . . . .

;  Pattern  - Player's Ship (With Rocket Exhaust, Frame 2)
L2768:  DB      $0D,$01         ; X,Y Displacement
        DB      $05,$04         ; X,Y Size
        DB  $03,$10,$28,$00,$00 ; . . . 3 . 1 . . . 2 2 . . . . . . . . .
        DB  $30,$F1,$2A,$FF,$40 ; . 3 . . 3 3 . 1 . 2 2 2 3 3 3 3 1 . . .
        DB  $41,$04,$AA,$AA,$A0 ; 1 . . 1 . . 1 . 2 2 2 2 2 2 2 2 2 2 . .
        DB  $0C,$1C,$22,$00,$00 ; . . 3 . . 1 3 . . 2 . 2 . . . . . . . .

; Animation table for 2 Player's Ships (With Rocket Exhaust)
L2780:  DB      $02
        DW      L2750           ; Pattern Address Rocket Exhaust #1
        DB      $02
        DW      L2768           ; Pattern Address Rocket Exhaust #2
        DB      $00
        DW      L2780           ; loop to Start of Rocket Exhaust Animation Table

;  Pattern  - Player's Ship (With Rocket Exhaust and Energy Shield, Frame 1)
L2789:  DB      $0D,$03         ; X,Y Displacement
        DB      $05,$08         ; X,Y Size
        DB  $00,$00,$77,$74,$00 ; . . . . . . . . 1 3 1 3 1 3 1 . . . . .
        DB  $00,$03,$00,$03,$74 ; . . . . . . . 3 . . . . . . . 3 1 3 1 .
        DB  $00,$41,$28,$00,$01 ; . . . . 1 . . 1 . 2 2 . . . . . . . . 1
        DB  $13,$0C,$2A,$FF,$43 ; . 1 . 3 . . 3 . . 2 2 2 3 3 3 3 1 . . 3
        DB  $30,$13,$AA,$AA,$A1 ; . 3 . . . 1 . 3 2 2 2 2 2 2 2 2 2 2 . 1
        DB  $41,$0C,$22,$00,$03 ; 1 . . 1 . . 3 . . 2 . 2 . . . . . . . 3
        DB  $00,$03,$00,$37,$74 ; . . . . . . . 3 . . . . . 3 1 3 1 3 1 .
        DB  $00,$00,$77,$40,$00 ; . . . . . . . . 1 3 1 3 1 . . . . . . .

;  Pattern  - Player's Ship (With Rocket Exhaust and Energy Shield, Frame 2)
L27B5:  DB      $0D,$03         ; X,Y Displacement
        DB      $05,$08         ; X,Y Size
        DB  $00,$00,$DD,$DC,$00 ; . . . . . . . . 3 1 3 1 3 1 3 . . . . .
        DB  $00,$01,$00,$01,$DC ; . . . . . . . 1 . . . . . . . 1 3 1 3 .
        DB  $03,$13,$28,$00,$03 ; . . . 3 . 1 . 3 . 2 2 . . . . . . . . 3
        DB  $30,$F1,$2A,$FF,$41 ; . 3 . . 3 3 . 1 . 2 2 2 3 3 3 3 1 . . 1
        DB  $41,$04,$AA,$AA,$A3 ; 1 . . 1 . . 1 . 2 2 2 2 2 2 2 2 2 2 . 3
        DB  $0C,$1C,$22,$00,$01 ; . . 3 . . 1 3 . . 2 . 2 . . . . . . . 1
        DB  $00,$01,$00,$1D,$DC ; . . . . . . . 1 . . . . . 1 3 1 3 1 3 .
        DB  $00,$00,$DD,$C0,$00 ; . . . . . . . . 3 1 3 1 3 . . . . . . .

;  Pattern  - Player's Ship (With Energy Shield, Frame 1)
L27E1:  DB      $07,$03         ; X,Y Displacement
        DB      $04,$08         ; X,Y Size
        DB      $07,$77,$40,$00 ; . . 1 3 1 3 1 3 1 . . . . . . .
        DB      $30,$00,$37,$40 ; . 3 . . . . . . . 3 1 3 1 . . .
        DB      $12,$80,$00,$10 ; . 1 . 2 2 . . . . . . . . 1 . .
        DB      $C2,$AF,$F4,$30 ; 3 . . 2 2 2 3 3 3 3 1 . . 3 . .
        DB      $4A,$AA,$AA,$10 ; 1 . 2 2 2 2 2 2 2 2 2 2 . 1 . .
        DB      $C2,$20,$00,$30 ; 3 . . 2 . 2 . . . . . . . 3 . .
        DB      $70,$03,$77,$40 ; 1 3 . . . . . 3 1 3 1 3 1 . . .
        DB      $07,$74,$00,$00 ; . . 1 3 1 3 1 . . . . . . . . .

;  Pattern  - Player's Ship (With Energy Shield, Frame 2)
L2805:  DB      $07,$03         ; X,Y Displacement
        DB      $04,$08         ; X,Y Size
        DB      $0D,$DD,$C0,$00 ; . . 3 1 3 1 3 1 3 . . . . . . .
        DB      $10,$00,$1D,$C0 ; . 1 . . . . . . . 1 3 1 3 . . .
        DB      $32,$80,$00,$30 ; . 3 . 2 2 . . . . . . . . 3 . .
        DB      $42,$AF,$F4,$10 ; 1 . . 2 2 2 3 3 3 3 1 . . 1 . .
        DB      $CA,$AA,$AA,$30 ; 3 . 2 2 2 2 2 2 2 2 2 2 . 3 . .
        DB      $42,$20,$00,$10 ; 1 . . 2 . 2 . . . . . . . 1 . .
        DB      $D0,$01,$DD,$C0 ; 3 1 . . . . . 1 3 1 3 1 3 . . .
        DB      $0D,$DC,$00,$00 ; . . 3 1 3 1 3 . . . . . . . . .

; ?? not used ?? Animation table for 2 Player's Ships (With Rocket Exhaust and Energy Shield)
L2829:  DB      $02
        DW      L2789           ; Pattern Address Rocket Exhaust and Energy Shield #1
        DB      $02
        DW      L27B5           ; Pattern Address Rocket Exhaust and Energy Shield #2
        DB      $00
        DW      L2829           ; loop to Start of Rocket Exhaust and Energy Shield Animation Table

; Animation table for 4 Player's Ships (With Rocket Exhaust and FLASHING Energy Shield)
L2832:  DB      $02
        DW      L2789           ; Pattern Address Rocket Exhaust and Energy Shield #1
        DB      $02
        DW      L27B5           ; Pattern Address Rocket Exhaust and Energy Shield #2
        DB      $02
        DW      L2750           ; Pattern Address Rocket Exhaust #1
        DB      $02
        DW      L2768           ; Pattern Address Rocket Exhaust #2
        DB      $00
        DW      L2832           ; loop to Start of Rocket Exhaust and FLASHING Energy Shield Animation Table

; ?? also not used ?? Animation table for 1 Player's Ship ?? (then 4 above !!)
L2841:  DB      $80
        DW      L2927           ; ?? NOT a Pattern Address ??
        DB      $28
        DW      L2832           ; ?? loop to Start of DIFFERENT Player's Ship Animation Table !!

; Animation table for 2 Player's Ships (With Energy Shield)
L2847:  DB      $02
        DW      L27E1           ; Pattern Address Energy Shield #1
        DB      $02
        DW      L2805           ; Pattern Address Energy Shield #2
        DB      $00
        DW      L2847           ; loop to Start of Energy Shield Animation Table

; Animation table for 1 Player's Ship (plain)
L2850:  DB      $FF
        DW      L2740           ; Pattern Address (plain) !!
        DB      $00
        DW      L2850           ; loop to Start of Player's Ship Animation table

; Animation table for 2 Player's Ships (With FLASHING Energy Shield)
L2856:  DB      $02
        DW      L27E1           ; Pattern Address Energy Shield #1
        DB      $02
        DW      L2805           ; Pattern Address Energy Shield #2
        DB      $08
        DW      L2740           ; Pattern Address Player's Ship (plain) !!
        DB      $00
        DW      L2856           ; loop to Start of FLASHING Energy Shield Animation Table

; Table of 3 Animation tables for Player's Ships
L2862:  DW      L2850           ; Start of a Animation Table for 1 Player's Ship (plain)
        DW      L2847           ; Start of a Animation Table for Energy Shield
        DW      L2856           ; Start of a Animation Table for FLASHING Energy Shield

;  Pattern  - TYPE-5 Fighter (Frame 1)
; aka Dragon Fly
L2868:  DB      $04,$02         ; X,Y Displacement
        DB      $02,$05         ; X,Y Size
        DB      $00,$00         ; . . . . . . . .
        DB      $3C,$00         ; . 3 3 . . . . .
        DB      $F5,$55         ; 3 3 1 1 1 1 1 1
        DB      $3C,$00         ; . 3 3 . . . . .
        DB      $00,$00         ; . . . . . . . .

;  Pattern  - TYPE-5 Fighter (Frame 2)
L2876:  DB      $04,$07         ; X,Y Displacement
        DB      $03,$0A         ; X,Y Size
        DB      $00,$00,$80     ; . . . . . . . . 2 . . .
        DB      $00,$02,$00     ; . . . . . . . 2 . . . .
        DB      $00,$08,$00     ; . . . . . . 2 . . . . .
        DB      $00,$20,$80     ; . . . . . 2 . . 2 . . .
        DB      $00,$82,$00     ; . . . . 2 . . 2 . . . .
        DB      $02,$08,$00     ; . . . 2 . . 2 . . . . .
        DB      $3C,$20,$C0     ; . 3 3 . . 2 . . 3 . . .
        DB      $C7,$5D,$00     ; 3 . 1 3 1 1 3 1 . . . .
        DB      $3C,$00,$00     ; . 3 3 . . . . . . . . .
        DB      $00,$00,$00     ; . . . . . . . . . . . .

;  Pattern  - TYPE-5 Fighter (Frame 2)
L2898:  DB      $04,$02         ; X,Y Displacement
        DB      $03,$0A         ; X,Y Size
        DB      $00,$00,$00     ; . . . . . . . . . . . .
        DB      $3C,$00,$00     ; . 3 3 . . . . . . . . .
        DB      $F5,$96,$00     ; 3 3 1 1 2 1 1 2 . . . .
        DB      $3C,$20,$C0     ; . 3 3 . . 2 . . 3 . . .
        DB      $02,$08,$00     ; . . . 2 . . 2 . . . . .
        DB      $00,$82,$00     ; . . . . 2 . . 2 . . . .
        DB      $00,$20,$80     ; . . . . . 2 . . 2 . . .
        DB      $00,$08,$00     ; . . . . . . 2 . . . . .
        DB      $00,$02,$00     ; . . . . . . . 2 . . . .
        DB      $00,$00,$80     ; . . . . . . . . 2 . . .

; Animation table for 3 TYPE-5 Fighters
L28BA:  DB      $02
        DW      L2868           ; Pattern Address TYPE-5 Fighter #1
        DB      $03
        DW      L2876           ; Pattern Address TYPE-5 Fighter #2
        DB      $02
        DW      L2868           ; Pattern Address TYPE-5 Fighter #1 (AGAIN !!)
        DB      $03
        DW      L2898           ; Pattern Address TYPE-5 Fighter #3
        DB      $00
        DW      L28BA           ; loop to Start of TYPE-5 Fighter Animation Table
; end of Patterns and Animation Tables

; Next 7 bytes Moved to $4F94 in RAM using MOVE block transfer routine
L28C9:  DB      $20
        DB      $01
        DB      $20
        DB      $2F
        DB      $01
        DB      $02
        DB      $17

; Next 7 bytes Moved to $4F8D in RAM using MOVE block transfer routine
L28D0:  DB      $00
        DB      $01
        DB      $00
        DB      $10
        DB      $01
        DB      $07
        DB      $10

; Next 8 SOUND bytes Sent using OUTI and then a word Read in
L28D7:  DB      $00             ; TONe Master Oscillator = 0
        DB      $2E             ; TONE A = 46
        DB      $59             ; TONE B = 89
        DB      $85             ; TONE C = 133
        DB      $00             ; VIBRAto range = 0, frequency = 0
        DB      $3F             ; VOLume C = 15, Noise Mode = 3
        DB      $FF             ; VOLume A = 15, VOLume B = 15
        DB      $20             ; VOLume Noise = 32
        DW      $0060           ; 72 for ??

; Move 14 bytes to RAM, then Send 8 SOUND bytes and Read 1 word for ??
L28E1:  CALL    L210E           ; clear ?? address, then Zero $4F9E ?? then ?? and on to ($4F9F)
        CALL    L211D           ; set $4F9E ?? to 1 for ??
        SYSSUK  MOVE            ; UPI MOVE block transfer
        DW      $4F94           ; ... Destination Address = 20372
        DW      $0007           ; ... Byte Count = 7
        DW      L28D0           ; ... Source Address = 10448
        ;
        SYSSUK  MOVE            ; UPI MOVE block transfer
        DW      $4F8D           ; ... Destination Address = 20365
        DW      $0007           ; ... Byte Count = 7
        DW      L28C9           ; ... Source Address = 10441
        ;
        LD      HL,L28D7        ; get 8 SOUND bytes + 1 word for ??
; multiple re-entry points to here
L28FA:  LD      BC,$080F
L28FD:  INC     C               ; write HL out TONMO through VOLN ...
        OUTI                    ; ... port Incrementing C and HL
        JR      NZ,L28FD        ; until B has counted down to 0
L2902:  XOR     A
        LD      ($4F9D),A       ; write 0 to ?? for ??
        LD      E,(HL)
        INC     HL
        LD      D,(HL)
        LD      ($4F9B),DE      ; write ?? word to ?? for ??
        LD      A,$01
        LD      ($4F9D),A       ; write 1 to ?? for ??
        RET

; Next 7 bytes Moved to $4F8D in RAM using MOVE block transfer routine
L2913:  DB      $10
        DB      $05
        DB      $10
        DB      $30
        DB      $01
        DB      $03
        DB      $17

; Next 8 SOUND bytes Sent using OUTI and then a word Read in
L291A:  DB      $10             ; TONe Master Oscillator = 16
        DB      $2E             ; TONE A = 46
        DB      $43             ; TONE B = 67
        DB      $70             ; TONE C = 112
        DB      $00             ; VIBRAto range = 0, frequency = 0
        DB      $3C             ; VOLume C = 12, Noise Mode = 3
        DB      $AA             ; VOLume A = 10, VOLume B =  = 10
        DB      $10             ; VOLume Noise = 16
        DW      $0018           ; 24 for ??

; Move 7 bytes to RAM, then Send 8 SOUND bytes and Read 1 word for ??
L2924:  CALL    L20DF           ; if $4F9E = 0 then Clear $4F9D through $4FAD and Silence SOUNDs, else clean-up
L2927:  SYSSUK  MOVE            ; UPI MOVE block transfer
        DW      $4F8D           ; ... Destination Address = 20365
        DW      $0007           ; ... Byte Count = 7
        DW      L2913           ; ... Source Address = 10515
        ;
        LD      HL,L291A
        JP      L28FA           ; to Send 8 SOUND bytes and Read 1 word for ??

; Next 7 bytes Moved to $4F94 in RAM using MOVE block transfer routine
L2935:  DB      $20
        DB      $FC
        DB      $20
        DB      $80
        DB      $01
        DB      $02
        DB      $10

; Next 8 SOUND bytes Sent using OUTI and then a word Read in
L293C:  DB      $20             ; TONe Master Oscillator = 32
        DB      $18             ; TONE A = 24
        DB      $30             ; TONE B = 48
        DB      $48             ; TONE C = 72
        DB      $00             ; VIBRAto range = 0, frequency = 0
        DB      $36             ; VOLume C = 6, Noise Mode = 3
        DB      $66             ; VOLume A = 6, VOLume B = 6
        DB      $18             ; VOLume Noise = 24
        DW      $0028           ; 40 for ??

; Next 8 SOUND bytes Sent using OUTI and then a word Read in
L2946:  DB      $20             ; TONe Master Oscillator = 32
        DB      $08             ; TONE A = 8
        DB      $18             ; TONE B = 24
        DB      $10             ; TONE C = 16
        DB      $10             ; VIBRAto range = 16, frequency = 0
        DB      $28             ; VOLume C = 8, Noise Mode = 2
        DB      $88             ; VOLume A = 8, VOLume B = 8
        DB      $38             ; VOLume Noise = 56
        DW      $0020           ; 32 for ??

; Move 7 bytes to RAM, then Send 8 SOUND bytes and Read 1 word for ??
L2950:  CALL    L20DF           ; if $4F9E = 0 then Clear $4F9D through $4FAD and Silence SOUNDs, else clean-up
        SYSSUK  MOVE            ; UPI MOVE block transfer
        DW      $4F94           ; ... Destination Address = 20372
        DW      $0007           ; ... Byte Count = 7
        DW      L2935           ; ... Source Address = 10549
        ;
        LD      HL,L293C
        JP      L28FA           ; to Send 8 SOUND bytes and Read 1 word for ??

; Move 7 bytes to RAM, then Send 8 SOUND bytes and Read 1 word for ??
L2961:  CALL    L20DF           ; if $4F9E = 0 then Clear $4F9D through $4FAD and Silence SOUNDs, else clean-up
        SYSSUK  MOVE            ; UPI MOVE block transfer
        DW      $4F94           ; ... Destination Address = 20372
        DW      $0007           ; ... Byte Count = 7
        DW      L2935           ; ... Source Address = 10549
        ;
        LD      A,$F8
        LD      ($4F95),A       ; 248 for ??
        LD      HL,L2946
        JP      L28FA           ; to Send 8 SOUND bytes and Read 1 word for ??

; Next 8 SOUND bytes Sent using OUTI and then a word Read in
L2977:  DB      $20             ; TONe Master Oscillator = 32
        DB      $2E             ; TONE A = 46
        DB      $80             ; TONE B = 128
        DB      $60             ; TONE C = 96
        DB      $00             ; VIBRAto range = 0, frequency = 0
        DB      $3A             ; VOLume C = 10, Noise Mode = 3
        DB      $AA             ; VOLume A = 10, VOLume B = 10
        DB      $23             ; VOLume Noise = 35
        DW      $0003           ; 3 for ??

; Next 8 SOUND bytes Sent using OUTI and then a word Read in
L2981:  DB      $24             ; TONe Master Oscillator = 36
        DB      $60             ; TONE A = 96
        DB      $70             ; TONE B = 112
        DB      $80             ; TONE C = 128
        DB      $00             ; VIBRAto range = 0, frequency = 0
        DB      $13             ; VOLume C = 3, Noise Mode = 1
        DB      $33             ; VOLume A = 3, VOLume B = 3
        DB      $26             ; VOLume Noise = 38
        DW      $0003           ; 3 for ??

; Send 8 SOUND bytes routine #1 ??
L298B:  CALL    L2116           ; write HERE as $4F9F then if $4F9E = 0 Clear $4F9D through $4FAD and Silence SOUNDs, else clean-up
        LD      HL,L2977
        JP      L28FA           ; to Send 8 SOUND bytes and Read 1 word for ??

; Send 8 SOUND bytes routine #2 ??
L2994:  CALL    L2116           ; write HERE as $4F9F then if $4F9E = 0 Clear $4F9D through $4FAD and Silence SOUNDs, else clean-up
        LD      HL,L2981
        JP      L28FA           ; to Send 8 SOUND bytes and Read 1 word for ??

; select Send 8 SOUND bytes routine #1 or routine #2 by A ??
L299D:  OR      A
        LD      HL,L298B        ; point at Send 8 SOUND bytes routine #1
        JR      NZ,L29A6
        LD      HL,L2994        ; point at Send 8 SOUND bytes routine #2
L29A6:  LD      ($4F9F),HL      ; save Routine as ??
        RET

; Next 7 bytes Moved to $4F94 in RAM using MOVE block transfer routine
L29AA:  DB      $42
        DB      $01
        DB      $42
        DB      $50
        DB      $04
        DB      $04
        DB      $14

; Next 7 bytes Moved to $4F8D in RAM using MOVE block transfer routine
L29B1:  DB      $23
        DB      $23
        DB      $23
        DB      $43
        DB      $08
        DB      $08
        DB      $10

; Next 8 SOUND bytes Sent using OUTI and then a word Read in
L29B8:  DB      $23             ; TONe Master Oscillator = 35
        DB      $2E             ; TONE A = 46
        DB      $46             ; TONE B = 70
        DB      $6A             ; TONE C = 106
        DB      $42             ; VIBRAto range = 2, frequency = 1
        DB      $28             ; VOLume C = 8, Noise Mode = 2
        DB      $88             ; VOLume A = 8, VOLume B = 8
        DB      $40             ; VOLume Noise = 64
        DW      $FFFF           ; -1 for ??
; !! second time Read another word
        DW      $FFFF           ; -1 for ?? again

; Move 7 bytes to RAM, then Send 8 SOUND bytes and Read 1 word for ??
L29C4:  CALL    L2116           ; write HERE as $4F9F then if $4F9E = 0 Clear $4F9D through $4FAD and Silence SOUNDs, else clean-up
        CALL    L211D           ; set $4F9E ?? to 1 for ??
        SYSSUK  MOVE            ; UPI MOVE block transfer
        DW      $4F94           ; ... Destination Address = 20372
        DW      $0007           ; ... Byte Count = 7
        DW      L29AA           ; ... Source Address = 10666
        ;
        LD      HL,L29B8
        JP      L28FA           ; to Send 8 SOUND bytes and Read 1 word for ??

; Move 7 bytes to RAM, then Send 8 SOUND bytes and Read 1 word for ??, then Read another word for ??
L29D8:  CALL    L210E           ; clear ?? address, then Zero $4F9E ?? then ?? and on to ($4F9F)
        CALL    L211D           ; set $4F9E ?? to 1 for ??
        SYSSUK  MOVE            ; UPI MOVE block transfer
        DW      $4F8D           ; ... Destination Address = 20365
        DW      $0007           ; ... Byte Count = 7
        DW      L29B1           ; ... Source Address = 10673
        ;
        LD      HL,L29B8        ; again ??
        CALL    L28FA           ; send 8 SOUND bytes and Read 1 word for ??
        INC     HL
        JP      L2902           ; to get another word to ?? for ??

; clear ?? address, then Zero $4F9E ?? then ?? and to ($4F9F) then Select ?? routine by A ?? and on to ?? Routine
L29F0:  PUSH    AF
        CALL    L210E           ; clear ?? address, then Zero $4F9E ?? then ?? and on to ($4F9F)
        POP     AF
        CALL    L299D           ; select Send 8 SOUND bytes routine #1 or routine #2 by A ??
        JP      (HL)            ; to Send 8 SOUND bytes Routine

; Next 7 bytes Moved to $4F94 in RAM using MOVE block transfer routine
L29F9:  DB      $80
        DB      $08
        DB      $10
        DB      $80
        DB      $03
        DB      $03
        DB      $10

; Next 7 bytes Moved to $4F8D in RAM using MOVE block transfer routine
L2A00:  DB      $40
        DB      $08
        DB      $40
        DB      $78
        DB      $06
        DB      $06
        DB      $17

; Next 8 SOUND bytes Sent using OUTI and then a word Read in
L2A07:  DB      $80             ; TONe Master Oscillator = 128
        DB      $40             ; TONE A = 64
        DB      $3E             ; TONE B = 62
        DB      $3C             ; TONE C = 60
        DB      $44             ; VIBRAto range = 4, frequency = 1
        DB      $2E             ; VOLume C = 14, Noise Mode = 2
        DB      $EE             ; VOLume A = 14, VOLume B = 14
        DB      $20             ; VOLume Noise = 32
        DW      $0030           ; 48 for ??

; TWICE move 7 bytes using MOVE block transfer, then Send 8 SOUND bytes and Read 1 word for ??
L2A11:  CALL    L210E           ; clear ?? address, then Zero $4F9E ?? then ?? and on to ($4F9F)
        CALL    L211D           ; set $4F9E ?? to 1 for ??
        LD      HL,L29C4        ; point at Move 7 bytes to RAM, then Send 8 SOUND bytes and Read 1 word for ??
        LD      ($4F9F),HL      ; ?? into ??
        SYSSUK  MOVE            ; UPI MOVE block transfer
        DW      $4F94           ; ... Destination Address = 20372
        DW      $0007           ; ... Byte Count = 7
        DW      L29F9           ; ... Source Address = 10745
        ;
        SYSSUK  MOVE            ; UPI MOVE block transfer
        DW      $4F8D           ; ... Destination Address = 20365
        DW      $0007           ; ... Byte Count = 7
        DW      L2A00           ; ... Source Address = 10752
        ;
        LD      HL,L2A07
        JP      L28FA           ; to Send 8 SOUND bytes and Read 1 word for ????

; Next 7 bytes Moved to $4F94 in RAM using MOVE block transfer routine
L2A33:  DB      $08
        DB      $01
        DB      $08
        DB      $18
        DB      $06
        DB      $06
        DB      $10

; Next 8 SOUND bytes Sent using OUTI and then a word Read in
L2A3A:  DB      $08             ; TONe Master Oscillator = 8
        DB      $25             ; TONE A = 37
        DB      $28             ; TONE B = 40
        DB      $2B             ; TONE C = 43
        DB      $06             ; VIBRAto range = 6, frequency = 0
        DB      $2F             ; VOLume C = 15, Noise Mode = 2
        DB      $FF             ; VOLume A = 15, VOLume B = 15
        DB      $00             ; VOLume Noise = 0
        DW      $0060           ; 92 for ??

; Move 7 bytes to RAM, then Send 8 SOUND bytes and Read 1 word for ??
L2A44:  CALL    L20E8           ; clear $4F9D through $4FAD then Silence SOUNDs
        CALL    L211D           ; set $4F9E ?? to 1 for ??
        SYSSUK  MOVE            ; UPI MOVE block transfer to Copy to $4F94 thru $4F9A
        DW      $4F94           ; ... Destination Address = 20372
        DW      $0007           ; ... Byte Count = 7
        DW      L2A33           ; ... Source Address = 10803
        ;
        LD      HL,L2A3A
        JP      L28FA           ; to Send 8 SOUND bytes and Read 1 word for ??
; end of Move 7 bytes to RAM, then Send 8 SOUND bytes and Read 1 word

; code !!
L2A58:  CALL    L2A44           ; Move 7 bytes to RAM, then Send 8 SOUND bytes and Read 1 word for ??
        LD      A,$19
        OUT     (VOLN),A        ; overrides VOLume Noise = 27
        LD      A,$3F
        OUT     (VOLC),A        ; overrides VOLume C = 15, Noise Mode = 3
        RET

; 10-word RAM table of 31-byte VECTOR Blocks !! is on-screem ??
L2A64:  DW      $41C1           ; C/T-1 ODD FIGHTERS VECTOR Block #1
        DW      $41A2           ; C/T-1 ODD FIGHTERS VECTOR Block #2
        DW      $4183           ; C/T-1 ODD FIGHTERS VECTOR Block #3
        DW      $4164           ; C/T-1 ODD FIGHTERS VECTOR Block #4
        DW      $4145           ; C/T-2 EVEN FIGHTERS VECTOR Block #1
        DW      $4126           ; C/T-2 EVEN FIGHTERS VECTOR Block #2
        DW      $4107           ; C/T-2 EVEN FIGHTERS VECTOR Block #3
; note: 4-word RAM table and $40E8 would fit in here !!
; $4085 (17-byte) FIGHTER'S SHOT VECTOR Block #1 (three uncommited ones !!)
; $4074 (17-byte) FIGHTER'S SHOT VECTOR Block #2
; $4063 (17-byte) FIGHTER'S SHOT VECTOR Block #3 used as base for (3 at) L2EF6: and (6 at) L36DD:
; $4061 (extra word !!) not used ??
        DW      $4042           ; C/T-6 BOMBS VECTOR Block #1, or ...
; $4040 (extra word !!) not used ??
        DW      $4021           ; C/T-6 BOMBS VECTOR Block #2 (base Vector for Clear)
        DW      $40E8           ; C/T-3 ENERGY STAR VECTOR Block (last Vector Cleared by L3C64:)

; 4-word RAM table of 17-byte VECTOR Blocks !! is on-screem ??
L2A78:  DW      $40C9           ; PLAYER'S SHIP (31-byte) VECTOR Block !!
        DW      $40B8           ; PLAYER'S SHOT VECTOR Block #1 (three more uncommited ones !!)
        DW      $40A7           ; PLAYER'S SHOT VECTOR Block #2
        DW      $4096           ; PLAYER'S SHOT VECTOR Block #3 and base for (3 at) L2EAA:
; end of 2 RAM tables of VECTOR Blocks

; Limit table for ALL VECTors (except Player's Ship and NARROWER TYPE-5 Fighter ??)
L2A80:  DB      $0A             ; 10 for X Left
        DB      $95             ; 149 for X Right
        DB      $13             ; 19 for Y Top
        DB      $46             ; 70 for Y Bottom

; Data Used in Move Block Transfer of 4 bytes into $4F2E
; ONLY for Player's Ship Limit table (alterable) in RAM !!
L2A84:  DB      $28             ; 40 for X Left
        DB      $3C             ; 60 for X Right
        DB      $11             ; 17 for Y Top
        DB      $48             ; 72 for Y Bottom

; with H = 0, L = byte VALUE; return 3-byte base pointer
L2A88:  PUSH    DE
        LD      IY,$4FC5        ; point IY at 3-byte VALUE base
        CALL    L2053           ; write 5-digit BCD number to it
        LD      HL,$4FC5        ; point at VALUE base again
        POP     DE
        RET

; add Current PLAYER and ?? into HL for ??
; with HL = $4F19, $4F11, $4F0D, $4F09, $4F15, $4F05, $4EFD, $4EF9 or $4F01
L2A95:  PUSH    DE
        LD      DE,($4F1F)      ; read CURRENT Player
        LD      D,$00
        ADD     HL,DE
        POP     DE
        RET

; multiple entries into previous routine
L2A9F:  LD      HL,$4F19
        JR      L2A95

L2AA4:  LD      HL,$4F11
        JR      L2A95

L2AA9:  LD      HL,$4F0D
        JR      L2A95

L2AAE:  LD      HL,$4F09
        JR      L2A95

L2AB3:  LD      HL,$4F15
        JR      L2A95

L2AB8:  LD      HL,$4F05
        JP      L2A95

L2ABE:  LD      HL,$4EFD
        JP      L2A95

L2AC4:  LD      HL,$4EF9
        JP      L2A95

L2ACA:  LD      HL,$4F01
        JP      L2A95
; end of multiple entries

; does Set C for Current INPUT Port
L2AD0:  LD      A,($4F1F)       ; read CURRENT Player
        ADD     A,$10
        LD      C,A
        RET

; read CURRENT Player's SCORE into HL, and its location in DE ??
L2AD7:  LD      A,($4F1F)       ; read CURRENT Player
        SLA     A
        LD      E,A
        LD      D,$00
        LD      HL,$4FA2
        ADD     HL,DE
        LD      E,(HL)
        INC     HL
        LD      D,(HL)
        DEC     HL
        EX      DE,HL
        RET

; convert ?? value to BCD, then display it as ALTernate FoNT in Control Panel box
; with HL = address of ??, E = X location (for FIGHTERS or STARS)
L2AE9:  LD      L,(HL)          ; read byte VALUE and ..
        LD      H,$00
        CALL    L2A88           ; write 5-digit BCD number and point HL to it
        LD      BC,$C20E        ; for Zero Suppress 2 Digits using Alt Font
                                ; ... and PLOP C0lor 3 on Color 2
L2AF2:  LD      D,$53           ; 83 for Y location
L2AF4:  LD      IX,FNTSML       ; point IX at $020D
L2AF8:  CALL    L2081           ; do Clear bytes $4FB0 and $4FB1
        SYSTEM  DISNUM          ; UPI DISplay NUMber
        ;
        CALL    L208E           ; do Clear byte $4FB1 and check $4FB0
        RET

; display Number of CURRENT Player's SHIPS remaining (as 0 thru 9 in small ALT FoNT)
L2B01:  LD      E,$99           ; 153 for X location (far Right side)
        LD      BC,$C124        ; for Zero Suppress 1 Digit using ALT Font
                                ; ... and X-OR C0lor 1 on Color 0
        CALL    L2AAE           ; add $4F09 and PLAYER into HL for ??
        JR      L2AF2           ; do zero $4FB0 and $4FB1, DISNUM in ALT Font then clear byte $4FB1 and check $4FB0 at 83 for Y location

; clear PLAYFIELD (fills _almost_ pixel LINEs 12 thru 75 !!)
L2B0B:  SYSSUK  FILL            ; UPI FILL memory with data
        DW      $41E1           ; ... Memory Address = 16865
        DW      $09D7           ; ... Byte Count = 2519
        DB      $00             ; ... Data = 0 (into NORMEM + 481 thru NORMEM + 2999)
        ;
        RET

; display SCORE and RADAR in Left colors and your CONTROL PANEL in Right colors
L2B13:  SYSSUK  RECTAN          ; UPI paint a RECTANgle of WHITE in LINEs 80 thru 90
        DB      $00             ; ... X = 0
        DB      $50             ; ... Y = 80
        DB      $A0             ; ... Width = 160
        DB      $0B             ; ... Height = 11
        DB      $FF             ; ... Color = 255
        ;
        SYSSUK  RECTAN          ; UPI paint a RECTANgle to Clear LINEs 81 thru 89 (hollow)
        DB      $01             ; ... X = 1
        DB      $51             ; ... Y = 81
        DB      $9E             ; ... Width = 158
        DB      $09             ; ... Height = 9
        DB      $00             ; ... Color = 0
        ;
        SYSSUK  RECTAN          ; UPI paint a RECTANgle of WHITE LINE for SCORE box edge
        DB      $32             ; ... X = 50
        DB      $50             ; ... Y = 80
        DB      $01             ; ... Width = 1
        DB      $0A             ; ... Height = 10
        DB      $FF             ; ... Color = 255
        ;
        SYSSUK  RECTAN          ; UPI paint a RECTANgle of BLUE Color 2 for CONTROL PANEL
        DB      $70             ; ... X = 112
        DB      $51             ; ... Y = 81
        DB      $2F             ; ... Width = 47
        DB      $09             ; ... Height = 9
        DB      $AA             ; ... Color = 170
        ;
        SYSSUK  RECTAN          ; UPI paint a RECTANgle of GREEN Color 2 for RADAR box
        DB      $33             ; ... X = 51
        DB      $51             ; ... Y = 81
        DB      $3C             ; ... Width = 60
        DB      $09             ; ... Height = 9
        DB      $55             ; ... Color = 85
        ;
        SYSSUK  RECTAN          ; UPI paint a RECTANgle of WHITE LINE for RADAR box edge
        DB      $6F             ; ... X = 111
        DB      $50             ; ... Y = 80
        DB      $01             ; ... Width = 1
        DB      $0A             ; ... Height = 10
        DB      $FF             ; ... Color = 255
        ;
        SYSSUK  RECTAN          ; UPI paint a RECTANgle of WHITE for RADAR Scope box
        DB      $46             ; ... X = 70
        DB      $52             ; ... Y = 82
        DB      $14             ; ... Width = 20
        DB      $07             ; ... Height = 7
        DB      $FF             ; ... Color = 255
        ;
        SYSSUK  RECTAN          ; UPI paint a RECTANgle of GREEN for RADAR Scope (hollow)
        DB      $47             ; ... X = 71
        DB      $53             ; ... Y = 83
        DB      $12             ; ... Width = 18
        DB      $05             ; ... Height = 5
        DB      $55             ; ... Color = 85
        ;
        SYSSUK  RECTAN          ; UPI paint a RECTANgle of GREEN for CENTER of RADAR Scope
        DB      $49             ; ... X = 73
        DB      $52             ; ... Y = 82
        DB      $0E             ; ... Width = 14
        DB      $07             ; ... Height = 7
        DB      $55             ; ... Color = 85
        ;
        SYSSUK  CHRDIS          ; UPI CHaRacter DISplay a YELLOW 'F' for enemy Fighters
        DB      $72             ; ... X = 114
        DB      $52             ; ... Y = 82
        DB      $2C             ; ... Options = 44 for X-OR Color 3 on Color 0
        DB      $46             ; ... Character = 70 for "ASCII F"
        ;
        SYSSUK  CHRDIS          ; UPI CHaRacter DISplay a YELLOW 'S' for energy Stars
        DB      $84             ; ... X = 132
        DB      $52             ; ... Y = 82
        DB      $2C             ; ... Options = 44 for X-OR Color 3 on Color 0
        DB      $53             ; ... Character = 83 for "ASCII S"
        ;
        XOR     A
        OUT     (MAGIC),A       ; clear MAGIC register
        LD      A,$EE           ; 238 for 2 WHITE pixels on BLUE Color 2
        LD      ($0CC8),A       ; 3 2 3 2 into multiple Screen RAN locations
        LD      ($0E08),A
        LD      ($0CCD),A
        LD      ($0E0D),A
        LD      A,$BA           ; 186 for 1 WHITE pixel on BLUE Color 2
        LD      ($0DE0),A       ; 2 3 2 2 into multiple Screen RAN locations
        LD      ($0CF0),A
        LD      ($0DE5),A
        LD      ($0CF5),A
        RET

; convert SCORE, STARS and FIGHTERS values into BCD numbers, and display them
L2B7E:  CALL    L2AD7           ; read CURRENT Player's SCORE into HL
        CALL    L2A88           ; write 5-digit BCD number and point HL to it
        LD      E,$07           ; 7 for X location (on Left side)
        LD      BC,$850C        ; for Zero Suppress 5 Digits using SYStem Font
                                ; ... and PLOP C0lor 3 on Color 0
        LD      D,$52           ; 82 for Y location
        CALL    L2AF8           ; do zero $4FB0 and $4FB1, DISNUM then clear byte $4FB1 and check $4FB0
        CALL    L2AB3           ; add $4F15 and PLAYER into HL for Stars
        LD      E,$8C
        CALL    L2AE9           ; convert STARS to BCD, then X-OR as ALTFNT at X = 140
        CALL    L2AB8           ; add $4F05 and PLAYER into HL for Fighters
        LD      E,$78
        JP      L2AE9           ; convert FIGHTERS to BCD, then X-OR ALTFNT at X = 120

; Vectored C/T-5 routine does loop FOREVER ??
; maybe Displaying SCORE, STARS and FIGHTERS, but Seting C/T #5 every time !!
L2B9E:  LD      HL,$4FA1
        XOR     A
        CP      (HL)
        LD      (HL),A
        CALL    NZ,L2B7E        ; if ?? display SCORE, STARS and FIGHTERS as BCD numbers
        LD      DE,$0505
        CALL    L20CB           ; do Set Counter Timer 5 to a 5
        JP      L2B9E           ; loop on Vectored C/T-5 routine !!
; end of Vectored C/T-5 routine

; All null-terminated TEXT Strings in one location !!
; L2BB0: note: Length Byte is NOT used !!
        DB      $09
L2BB1:  DB      "GAME OVER",$00
; L2BBB: ditto NOT used !!
        DB      $0D
L2BBC:  DB      "COSMIC RAIDER",$00
; L2BCA: "" NOT used !!
        DB      $10
L2BCB:  DB      "ENTERING SECTOR ",$00
; L2BDC: ... NOT used !!
        DB      $06
L2BDD:  DB      "SECTOR",$00
; L2BE4: .. NOT used !!
        DB      $15
L2BE5:  DB      "INTENSITY      0 TO 9",$00
; L2BFB: . NOT used !!
        DB      $0A
L2BFC:  DB      "# OF SHIPS",$00
; L2C07: NOT used !!
        DB      $08
L2C08:  DB      "PLAYER 1",$00
; L2C11: NOT used !!
        DB      $08
L2C12:  DB      "PLAYER 2",$00
; L2C1B: NOT used !!
        DB      $08
L2C1C:  DB      "PLAYER 3",$00
; L2C25: NOT used !!
        DB      $08
L2C26:  DB      "PLAYER 4",$00
; L2C2F: NOT used !!
        DB      $05
L2C30:  DB      "BONUS",$00
; L2C36: NOT used !!
        DB      $09
L2C37:  DB      "GOOD LUCK",$00
; end of Length Byte is NOT used !!

; Table of "PLAYER 1-4" strings
L2C41:  DW      L2C08
        DW      L2C12
        DW      L2C1C
        DW      L2C26

; display "ENTERING SECTOR " and take away 1/2 Space, then display SECTOR Number
L2C49:  CALL    L2A9F           ; add $4F19 and PLAYER into HL for ??
        LD      A,(HL)          ; read byte VALUE then ...
        LD      L,A
        LD      H,$00
        CALL    L2A88           ; write 5-digit BCD number and point HL to it
        SYSSUK  STRDIS          ; UPI STRing DISplay
        DB      $0C             ; ... X = 12
        DB      $10             ; ... Y = 16
        DB      00001000B       ; ... Options - ON Color $10
        DW      L2BCB           ; ... String Address "ENTERING SECTOR "
        ;
        DEC     E               ; keep new Y location
        DEC     E
        DEC     E
        DEC     E               ; new X - 4 for X location
        LD      BC,$8208        ; for Zero Suppress 2 Digits using SYStem Font
                                ; ... and PLOP C0lor 1 on Color 0
        LD      HL,$4FC5        ; point at VALUE base again
        JP      L2AF8           ; do zero $4FB0 and $4FB1, DISNUM then clear byte $4FB1 and check $4FB0

; display "GAME OVER"
L2C67:  LD      C,00100100B     ; ... Options - XOR Write, ON Color $01
        LD      HL,L2BB1        ; ... String Address "GAME OVER"
        SYSTEM  STRDIS          ; UPI STRing DISplay
        ;
        RET

; add 3/4 of a Space, then display "BONUS"
L2C6F:  LD      A,$06
        ADD     A,E             ; move X Coordinate right 6
        LD      E,A
        LD      C,$2C           ; ... Options - XOR Write, ON Color $03
        LD      HL,L2C30        ; ... String Address "BONUS"
        SYSTEM  STRDIS          ; UPI STRing DISplay
        ;
        RET

; display Energy Star (Frame 3)
L2C7B:  LD      D,$0D           ; new Y Coordinate = 13
        LD      A,$20           ; ... Magic Register - XOR Write
        LD      HL,L2574        ; ... Pattern Address Energy Star (Frame 3)
        SYSTEM  WRITR           ; UPI WRITe RELATIVE
        ;
        CALL    L2AB3           ; add $4F15 and PLAYER into HL for ??
        INC     (HL)            ; and start animation ??
        RET

; display "PLAYER 1" through "PLAYER 4" as needed
L2C89:  PUSH    DE
        LD      A,($4F1F)       ; read CURRENT Player
        LD      HL,L2C41        ; ... Table of "PLAYER 1-4" strings
        SYSTEM  INDEXW          ; UPI INDEX Word by A
        ;
        EX      DE,HL
        POP     DE
        LD      D,$10           ; ... Y Coordinate = 16
        LD      C,$2C           ; ... MAGIC Register = XOR Write, ON Color $03
        SYSTEM  STRDIS          ; UPI STRing DISplay
        ;
        RET

; display "PLAYER 1 through 4", "BONUS" and a Player's SHIP then NONE, 1 or 2 Energy STAR(s)
L2C9B:  PUSH    BC
        LD      E,$04           ; ... X Coordinate = 4
        CALL    L2C89           ; display "PLAYER 1" thru "PLAYER 4" as needed
        CALL    L2C6F           ; add 3/4 of a Space, then display "BONUS"
        SYSSUK  WRITR           ; UPI WRITe RELATIVE
        DB      116             ; ... X Coordinate
        DB      17              ; ... Y Coordinate
        DB      $20             ; ... Magic Register for X-OR
        DW      L2740           ; ... Pattern Address - Player's Ship (plain)
        ;
        POP     BC
        PUSH    BC
        LD      A,B
        OR      A               ; any BONUS Energy STARs given ?
        JR      Z,L2CB6
        LD      E,$82           ; ... X Coordinate = 130
        CALL    L2C7B           ; display Energy Star (Frame 3)
L2CB6:  POP     BC
        LD      A,B
        CP      $02             ; are 2 Energy STARs given ?
        JR      NZ,L2CC1
        LD      E,$8D           ; ... X Coordinate = 141
        CALL    L2C7B           ; display Energy Star (Frame 3)
L2CC1:  CALL    L2AAE           ; add $4F09 and PLAYER into HL for ??
        INC     (HL)
        JP      L2B01           ; to display Number of CURRENT Player's SHIPS remaining

; display "PLAYER 1 - 4", "BONUS" and 1, 2 or 3 STAR(s) then SCORE, STARS and FIGHTERS
L2CC8:  PUSH    BC
        LD      E,$04           ; ... X Coordinate = 4
        CALL    L2C89           ; display "PLAYER 1" thru "PLAYER 4" as needed
        CALL    L2C6F           ; add 3/4 of a Space, then display "BONUS"
        LD      E,$74           ; ... X Coordinate = 116
        CALL    L2C7B           ; display an Energy Star (Frame 3) ALWAYS !!
        POP     BC
        PUSH    BC
        LD      A,B
        CP      $02             ; are 2 or more Energy STARs given ?
        JR      C,L2CE2
        LD      E,$80           ; ... X Coordinate = 128
        CALL    L2C7B           ; display Energy Star (Frame 3)
L2CE2:  POP     BC
        LD      A,B
        CP      $03             ; are 3 or more Energy STARs given ?
        JR      NZ,L2CED
        LD      E,$8C           ; ... X Coordinate = 140
        CALL    L2C7B           ; display Energy Star (Frame 3)
L2CED:  JP      L2B7E           ; to display SCORE, STARS and FIGHTERS as BCD numbers

; display "PLAYER 1 through 4" and add 5/8ths of a Space, then display "GOOD LUCK"
L2CF0:  LD      E,$0C           ; ... X Coordinate = 12
        CALL    L2C89           ; display "PLAYER 1" thru "PLAYER 4" as needed
        INC     E               ; move X Coordinate right 5
        INC     E
        INC     E
        INC     E
        INC     E
        LD      C,$2C           ; ... MAGIC Register = XOR Write, ON Color $03
        LD      HL,L2C37        ; ... String Address "GOOD LUCK"
        SYSTEM  STRDIS          ; UPI STRing DISplay
        ;
        RET

; display "PLAYER 1 through 4" and add 5/8ths of a Space, then display "GAME OVER"
L2D02:  LD      E,$0C           ; ... X Coordinate = 12
        CALL    L2C89           ; display "PLAYER 1" thru "PLAYER 4" as needed
        INC     E               ; move X Coordinate right 5
        INC     E
        INC     E
        INC     E
        INC     E
        JP      L2C67           ; to display "GAME OVER"

; display "GAME OVER"
L2D0F:  LD      DE,$1030        ; for X = 48, Y = 16
        JP      L2C67           ; to display "GAME OVER"

; display incremental Super BONUS for destroying a BOMB (shows on Playfield !!)
L2D15:  LD      H,(IX+$20)      ; read current SUPER Bonus ??
        LD      L,(IX+$1F)
        LD      E,(IX+VBXH)     ; read current ?? X location
        DEC     E               ; move X Coordinate left 6
        DEC     E
        DEC     E
        DEC     E
        DEC     E
        DEC     E
        LD      D,(IX+VBYH)     ; read current ?? Y location
        DEC     D               ; move Y Coordinate up 4 rows
        DEC     D
        DEC     D
        DEC     D
        CALL    L2A88           ; write 5-digit BCD number and point HL to it
        LD      BC,$C42C        ; for Zero Suppress 4 Digits using ALT Font
                                ; ... and X-OR C0lor 3 on Color 0
        PUSH    IX
        CALL    L2AF4           ; do zero $4FB0 and $4FB1, DISNUM in ALT Font then clear byte $4FB1 and check $4FB0
        POP     IX
        RET

; display All Player's NUMBER, SCORE, "SECTOR" NUMBER, display a SHIP and count of
; Remaing SHIPs and also HIGHLIGHTS Player Number in the list (to make it obvious !!)
; ... follows "ENTERING SECTOR " Number and next line "PLAYER " Number "GOOD LUCK"
L2D39:  LD      A,($4F1F)       ; read CURRENT Player
        INC     A
        LD      B,A
        LD      C,$0C           ; 12 for quantum
        LD      A,$0F           ; 15 lines for Y stert
L2D42:  ADD     A,C             ; compute 15 + 12 * Current PLAYER 1 to 4
        DJNZ    L2D42
        LD      D,A             ; ... Y = (27, 39, 51, or 63 for TEXT Row)
        LD      E,$0A           ; ... X = 10
        LD      BC,$0908        ; ... Y-Size, X-Size (cursor sized)
        LD      A,$55           ; ... Color = 255 for RED box)
        SYSTEM  RECTAN          ; UPI paint a RECTANgle (around Current Player's NUMBER !!)
        ;
L2D4F:  LD      A,($4F1F)       ; read CURRENT Player again
        PUSH    AF              ; store CURRENT Player
        XOR     A
        LD      ($4F1F),A       ; clear THIS Player for loop
        LD      A,(NUMPLY)      ; read $4FF3
        LD      B,A
        LD      D,$10           ; Y = 16 (to start 1 line lower)
; loop here for each Player's Score and other INFORMATION
L2D5D:  PUSH    BC
        LD      A,$0C           ; 12 for quantum, and ...
        LD      E,A             ; ... also for X coordinate
        ADD     A,D
        LD      D,A             ; ... Y coordinate (28, 40, 52, or 64 for TEXT Row)
        LD      C,00100100B     ; ... Options - XOR Write, ON Color $01
        LD      A,($4F1F)       ; read THIS Player (inside loop)
        ADD     A,$31           ; ... ASCII Character to Display "1" through "4"
        SYSTEM  CHRDIS          ; UPI CHaRacter DISplay (Current Player lines up with box !!)
        ;
        PUSH    DE
        CALL    L2AD7           ; read THIS Player's SCORE into HL
        POP     DE
        CALL    L2A88           ; write 5-digit BCD number and point HL to it
        INC     D               ; Y down a Line,
        INC     E               ; and X right 3
        INC     E
        INC     E
        LD      BC,$C52C        ; for Zero Suppress 5 Digits using ALT Font
                                ; ... and X-OR C0lor 3 on Color 0
        CALL    L2AF4           ; do zero $4FB0 and $4FB1, DISNUM in ALT Font then clear byte $4FB1 and check $4FB0
        CALL    L2A9F           ; add $4F19 and PLAYER into HL for ??
        LD      A,(HL)          ; !! must be Sector NUMBER !!
        OR      A
        JR      NZ,L2D87
        LD      A,$01           ; if NONE, stick one in there anyway !!
L2D87:  LD      H,$00
        LD      L,A
        CALL    L2A88           ; write 5-digit BCD number and point HL to it
        DEC     D               ; ... move Y Coordinate up a Line
        LD      A,$08           ; and X Coordinate right 8 pixels
        ADD     A,E
        LD      E,A             ;
        LD      C,00100100B     ; ... Options - XOR Write, ON Color $01
        LD      HL,L2BDD        ; ... String Address "SECTOR"
        SYSTEM  STRDIS          ; UPI STRing DISplay
        ;
        INC     E               ; keep new Y location
        INC     E
        INC     E               ; new X + 3 for X location
        LD      HL,$4FC5        ; point at VALUE base again
        LD      BC,$822C        ; for Zero Suppress 2 Digits using SYStem Font
                                ; ... and PLOP C0lor 3 on Color 0
        CALL    L2AF8           ; do zero $4FB0 and $4FB1, DISNUM then clear byte $4FB1 and check $4FB0
        PUSH    DE
        LD      A,$03           ; ... move X Coordinate right 3
        ADD     A,E
        LD      E,A
        LD      A,$20           ; ... Magic Register for X-OR
        LD      HL,L2740        ; ... Pattern Address - Player's Ship (plain)
        SYSTEM  WRITR           ; UPI WRITe RELATIVE
        ;
        POP     DE
        LD      A,$1D           ; ... move (same old) X Coordinate right 29
        ADD     A,E
        LD      E,A
        CALL    L2AAE           ; add $4F09 and PLAYER into HL for REMAINING Ships
        LD      BC,$012C        ; for 1 Digit using SYStem Font X-OR C0lor 3 on Color 0
        CALL    L2AF8           ; do zero $4FB0 and $4FB1, DISNUM then clear byte $4FB1 and check $4FB0
        LD      HL,$4F1F        ; point at THIS Player one last time
        INC     (HL)
        POP     BC
        DJNZ    L2D5D           ; loop for NEXT Player
        POP     AF              ; restore CURRENT Player
        LD      ($4F1F),A       ; write CURRENT Player
        RET

; ?? move ONE Fighter, Bomb or Ship (only if on-screen ??)
L2DCB:  LD      H,(IX+VBDXL)    ; read Delta X Lo for ??
        LD      L,(IX+VBTIMB)   ; read TIMe Base
        LD      D,(IX+VBSTAT)   ; read STATus byte
        LD      E,(IX+VBMR)     ; read Magic Register
L2DD7:  ADD     HL,DE
        ADD     HL,BC
        DEC     A
        JR      NZ,L2DD7
        RES     3,(IX+VBDXH)    ; fiddle with Delta X Hi
        BIT     0,(IX+VBDXH)
        JR      Z,L2E1F
        LD      A,H
        LD      B,(IY+VBMR)     ; read Magic Register
        CP      $CF
        JR      NC,L2E05        ; FLIP and FLOP with OR or XOR ?
        BIT     4,(IX+VBDXH)    ; more with Delta X Hi
        JR      Z,L2DFA
        EX      AF,AF'
        LD      A,$05
        ADD     A,B
        LD      B,A
        EX      AF,AF'
L2DFA:  CP      B
        JR      C,L2E05
        LD      B,(IY+VBSTAT)   ; read VB STATus for ??
        CP      B
        JR      C,L2E1F
        JR      Z,L2E1F
L2E05:  SET     3,(IX+VBDXH)    ; more with Delta X Hi
        LD      H,B
        LD      L,$00
        BIT     1,(IX+VBDXH)    ; more with Delta X Hi
        JR      Z,L2E1F
        LD      A,D
        CPL
        LD      D,A
        LD      A,E
        CPL
        LD      E,A
        INC     DE
        LD      (IX+VBMR),E     ; save Magic Register
        LD      (IX+VBSTAT),D   ; save STATus
L2E1F:  LD      (IX+VBTIMB),L   ; save TIMe Base
        LD      (IX+VBDXL),H    ; save Delta X Lo
        RET

; ?? move ONE Fighter, Bomb or Ship (on-screen or NOT ??)
; ?? IX points at  ??  for erase/move/draw ??
; HL is 4-byte data ?? goes into IY for ?? VECTor Limit Table ??
L2E26:  OR      A
        RET     Z
        PUSH    HL
        POP     IY
        LD      BC,($4F26)
L2E2F:  PUSH    IX
        PUSH    AF
        LD      DE,$0003
        ADD     IX,DE
        CALL    L2DCB
        POP     AF
        LD      DE,$0005
        ADD     IX,DE
        INC     IY
        INC     IY
        LD      BC,$0000
        CALL    L2DCB
        POP     IX
        RET

; initalize $4FFD and $4FFB as an User UPI Routine, even number $80 (or $81 for SUCK)
L2E4D:  LD      HL,L20C7-128
        LD      (USERTB),HL     ; USER Table Base + routine = JumP address
        LD      HL,L20C9-64
        LD      (UMARGT),HL     ; User Mask ARGument Table + (routine / 2)
; ... and run it in a loop forever !!
L2E59:  LD      HL,L2E59        ; store fake RETurn address back to here !!
        PUSH    HL
        EI                      ; allow INTERRUPT Looping to begin
        SYSSUK  $80             ; User MACRO routine 00 (L20C7) basically SENTRY + extra
        DW      ALKEYS          ; ... User Argument (DE Register) $0214 for All KEYS mask
        ;
        SYSSUK  DOIT            ; UPI DOIT table, branch to translation handler
        DW      L21C5           ; ... Do It table Address = 8645 for C/T 0 to 7
        ;
        RET                     ; and ...urn to Fake loop
; end of User MACRO routine 00 forever loop

; does copy 17 bytes from L2E99 (or L2EE5) to EMPTY VECTOR Block in RAM and then ??
; with A = +8/-8 (or +11/-11) Offset for ?? ; DE = $FBC0 or $0440 (or $FC00 or $0400)
L2E67:  PUSH    DE              ; store DeltaX ??
        PUSH    IY              ; store ?? Vector Block
        POP     DE              ; now destination
        LD      BC,$0011        ; 17 for Byte Count
        LDIR                    ; from HL source
        LD      D,(IX+VBXH)     ; read ?? Vector Block X coord Hi
        ADD     A,D
        LD      (IY+VBXH),A     ; write to RAM with OFFSET
        LD      D,(IX+VBYH)     ; read ?? Vector Block Y coord Hi
        LD      A,(IY+VBYH)     ; read from RAM Y coord Hi
        ADD     A,D
        LD      (IY+VBYH),A     ; write SUM to RAM
        POP     DE
        LD      (IY+VBDXL),E    ; write DeltaX to RAM
        LD      (IY+VBDXH),D
        PUSH    IX
        PUSH    IY
        POP     IX              ; now VECTOR Block in RAM
        CALL    L2497           ; write 1 byte to Magic RAM and check for COLLISION
        POP     IX              ; restore ?? Vector Block
        RET

; 2-bytes to copy to $4063 ??
L2E94:  DB      $04
        DB      $96

; MIXED data for PLAYER'S SHOTS
L2E96:  DW      L2A64          ; 10-word RAM table of 31-byte VECTOR Blocks
        DB      $09            ; 9 for check for Collision with FIGHTERS (not ENERGY STAR)

; 17-bytes PLAYER'S SHOT Vector Block template to copy to EMPTY VECTOR Block in RAM
L2E99:  DB      $20             ; $00 - use as (IX+VBMR) for MAGIC Register = XOR
        DB      $FF             ; $01 - (IX+VBSTAT) byte for STATus byte, preset to -1 for ??
                                        ; note: bit 6 = VBBLNK for BLaNK bit = 1,
                                        ; and bit 7 = VBSACT for ACTive bit = 1
        DB      $FF             ; $02 - (IX+VBTIMB) byte for TIMe Base = -1 ??
        DB      $00             ; $03 - (IX+VBDXL) byte for Delta for X Low = 0
        DB      $00             ; $04 - (IX+VBDXH) byte for Delta for X Hi = 0
        DB      $00             ; $05 - (IX+VBXL) byte for X coord Low = 0
        DB      $00             ; $06 - (IX+VBXH) byte for X coord Hi = 0 (Left edge)
        DB      $05             ; $07 - (IX+VBXCHK) byte for X CHecK flags, with:
                                        ; note: bit 0 = VBCLMT for LiMiT bit = 1,
                                        ; bit 1 = VBCREV for REVerse delta on limit attain bit = 0,
                                        ; and bit 2 = VBCLAT for X Limit ATtained bit = 1
        DB      $00             ; $08 - (IX+VBDYL) byte for Delta for Y Low = 0
        DB      $00             ; $09 - (IX+VBDYH) byte for Delta for Y Hi = 0
        DB      $00             ; $0A - (IX+VBYL) byte for Y coord Low = 0
        DB      $01             ; $0B - (IX+VBYH) byte for Y coord Hi = 1 from Top
        DB      $40             ; $0C - (IX+VBYCHK) byte for Y CHecK flags, preset to 64
                                        ; note: bit 0 = VBCLMT for LiMiT bit (probably = 0),
                                        ; bit 1 = VBCREV for REVerse delta on limit attain bit,
                                        ; and bit 2 = VBCLAT for Y Limit ATtained bit
        DB      $00             ; $0D - (IX+VBOAL) byte for Old Address Low = 0
        DB      $00             ; $0E - (IX+VBOAH) byte for Old (Blanking) Address Hi = 0
        DB      $96             ; $0F - word L2E96 for pointer to PLAYER'S SHOTS
        DB      $2E             ; $10 - PLAYER'S SHOTS data table in ROM part 2

; Look for Empty PLAYER'S SHOT Vector Block from these: $4096, $40A7 or $40B8
L2EAA:  LD      HL,$4096        ; point at base (of 3) 17-byte VECTOR Blocks
        LD      DE,$0011        ; 17 for VECTOR Blocks in RAM quantum
        INC     HL
        INC     HL
        LD      A,(HL)          ; read VBTIMB byte in first VECTOR Block in RAM
        OR      A
        JR      Z,L2EBF
        ADD     HL,DE
        LD      A,(HL)          ; read VBTIMB byte in second VECTOR Block in RAM
        OR      A
        JR      Z,L2EBF
        ADD     HL,DE
        LD      A,(HL)          ; read VBTIMB byte in third VECTOR Block in RAM
        OR      A
        RET     NZ              ; bail if NONE are Empty !!
L2EBF:  DEC     HL
        DEC     HL              ; back to first byte of EMPTY VECTOR Block in RAM
        PUSH    HL
        POP     IY              ; make Index Y point to it !!
        LD      A,($40C9+$13)   ; read PLAYER'S SHIP VB UNKNOWN byte at $40DC ??
        BIT     0,A
        LD      A,$08           ; 8 for POSitive X Offset
        JR      NZ,L2ED2
        LD      DE,$0440        ; 4.4 for Delta X
        JR      L2ED7

L2ED2:  LD      DE,$FBC0        ; -4.4 for Delta X
        NEG                     ; -8 for NEGative X Offset
L2ED7:  LD      HL,L2E99        ; point at PLAYER'S SHOT Vector Block template
        CALL    L2E67           ; do Copy 17 bytes from L2E99 to IY and then ??
        JP      L2950           ; to Move 7 bytes to RAM, then Send 8 SOUND bytes and Read 1 word for ??
; end of Look for Empty PLAYER'S SHOT Vector Block from these: $4096, $40A7 or $40B8

; L2EE0: NOT used !! copy to ??
        DB      $04
        DB      $96

; MIXED data for FIGHTER'S SHOTS
L2EE2:  DW      L2A78           ; 4-word RAM table of (first is 31-byte) VECTOR Blocks
        DB      $01             ; 1 for check for Collision with PLAYER ONLY !!

; 17-bytes FIGHTER'S SHOT Vector Block template to copy to EMPTY VECTOR Block in RAM
L2EE5:  DB      $20              ; $00 - use as (IX+VBMR) for MAGIC Register = XOR
        DB      $FF              ; $01 - (IX+VBSTAT) byte for STATus byte, preset to -1 for ??
                                         ; note: bit 6 = VBBLNK for BLaNK bit = 1,
                                         ; and bit 7 = VBSACT for ACTive bit = 1
        DB      $FF              ; $02 - (IX+VBTIMB) byte for TIMe Base = -1 ??
        DB      $00              ; $03 - (IX+VBDXL) byte for Delta for X Low = 0
        DB      $00              ; $04 - (IX+VBDXH) byte for Delta for X Hi = 0
        DB      $00              ; $05 - (IX+VBXL) byte for X coord Low = 0
        DB      $00              ; $06 - (IX+VBXH) byte for X coord Hi = 0 (Left edge)
        DB      $05              ; $07 - (IX+VBXCHK) byte for X CHecK flags, with:
                                         ; note: bit 0 = VBCLMT for LiMiT bit = 1,
                                         ; bit 1 = VBCREV for REVerse delta on limit attain bit = 0,
                                         ; and bit 2 = VBCLAT for X Limit ATtained bit = 1
        DB      $00              ; $08 - (IX+VBDYL) byte for Delta for Y Low = 0
        DB      $00              ; $09 - (IX+VBDYH) byte for Delta for Y Hi = 0
        DB      $00              ; $0A - (IX+VBYL) byte for Y coord Low = 0
        DB      $00              ; $0B - (IX+VBYH) byte for Y coord Hi = 0 from Top
        DB      $40              ; $0C - (IX+VBYCHK) byte for Y CHecK flags, preset to 64
                                         ; note: bit 0 = VBCLMT for LiMiT bit (probably = 0),
                                         ; bit 1 = VBCREV for REVerse delta on limit attain bit,
                                         ; and bit 2 = VBCLAT for Y Limit ATtained bit
        DB      $00              ; $0D - (IX+VBOAL) byte for Old Address Low = 0
        DB      $00              ; $0E - (IX+VBOAH) byte for Old (Blanking) Address Hi = 0
        DB      $E2              ; $0F - word L2EE2 for pointer to FIGHTER'S SHOTS
        DB      $2E              ; $10 - FIGHTER'S SHOTS data table in ROM part 2

; Look for Empty FIGHTER'S SHOT Vector Block from these: $4063, $4074 or $4085
L2EF6:  LD      HL,$4063        ; point at base (of 3) 17-byte VECTOR Blocks
        LD      DE,$0011        ; 17 for VECTOR Blocks in RAM quantum
        INC     HL
        INC     HL
        LD      A,(HL)          ; read VBTIMB byte in first VECTOR Block in RAM
        OR      A
        JR      Z,L2F0B
        ADD     HL,DE
        LD      A,(HL)          ; read VBTIMB byte in second VECTOR Block in RAM
        OR      A
        JR      Z,L2F0B
        ADD     HL,DE
        LD      A,(HL)          ; read VBTIMB byte in third VECTOR Block in RAM
        OR      A
        RET     NZ              ; bail if NONE are Empty !!
L2F0B:  DEC     HL
        DEC     HL              ; back to first byte of EMPTY VECTOR Block in RAM
        PUSH    HL
        POP     IY              ; make Index Y point to it !!
        LD      A,($40CF)
        SUB     (IX+VBXH)       ; minus X location Hi
        LD      A,$0B           ; 11 for POSitive X Offset
        JR      C,L2F1F
        LD      DE,$0400        ; 4.0 for Delta X
        JR      L2F24

L2F1F:  LD      DE,$FC00        ; -4.0 for Delta X
        NEG                     ; -11 for NEGative X Offset
L2F24:  LD      HL,L2EE5        ; point at IGHTER'S SHOT Vector Block template
        CALL    L2E67           ; do Copy 17 bytes from L2EE5 to IY and then ??
        JP      L2961           ; to Move 7 bytes to RAM, then Send 8 SOUND bytes and Read 1 word for ??
; end of Look for Empty FIGHTER'S SHOT Vector Block

; does this ONCE for EXIT Routine ??
L2F2D:  LD      E,(IX+VBXH)     ; read X location Hi
        LD      A,(IX+VBYH)     ; read Y location Hi
        LD      D,$00
        LD      HL,$0000
        LD      B,$00
        AND     $F8
        LD      C,A
        ADD     HL,BC
        ADD     HL,BC
        ADD     HL,BC
        ADD     HL,BC
        ADD     HL,BC
        SRL     E
        SRL     E
        SRL     E
        LD      A,$FE
        ADD     A,E
        CP      $F0
        JR      C,L2F50
        XOR     A
L2F50:  LD      E,A
        LD      C,E
        SRL     E
        SRL     E
        ADD     HL,DE
        LD      A,(IX+$1C)
        AND     $FC
        LD      B,A
        LD      A,C
        AND     $03
        OR      B
        LD      (IX+$1C),A
        LD      B,(IX+$1B)
        LD      D,$05
        XOR     A
L2F6A:  ADD     A,D
        DJNZ    L2F6A
        ADD     A,$08
        ADD     A,L
        LD      L,A
        LD      A,$00
        ADC     A,H
        LD      H,A
        LD      DE,$0C80
        ADD     HL,DE
        LD      (IX+$1D),L
        LD      (IX+$1E),H
        RET
; end of ONCE for EXIT Routine

; does this TWICE for EXIT Routine ??
L2F80:  LD      L,(IX+$1D)
        LD      H,(IX+$1E)
        LD      A,(IX+$1C)
        LD      C,A
        AND     MRSHFT          ; mask with $03 for ONLY the SHiFT bits
        SET     MRXOR,A         ; set bit 5 for eXclusive-OR writes
        OUT     (MAGIC),A       ; write MAGIC register
        LD      A,C
        AND     $C0
        LD      (HL),A
        RET
; end of TWICE for EXIT Routine

; EXIT Routine for ??
L2F95:  DEC     (IX+$1A)
        RET     NZ
        LD      (IX+$1A),$04
        CALL    L2F80           ; do this twice ...
        CALL    L2F2D           ; do this once !!
        JP      L2F80           ; ... to this again
; end of EXIT Routine

L2FA6:  XOR     A
        BIT     2,(IX+VBXCHK)   ; test UNKNOWN bit in X CecHK
        RET     Z
        BIT     4,(IX+VBXCHK)   ; test UNKNOWN bit in X CecHK
        RET     NZ
        LD      L,(IX+$0F)
        LD      H,(IX+$10)
        LD      DE,$0000
        ADD     HL,DE
        LD      E,(HL)
        INC     HL
        LD      D,(HL)
        INC     HL
        LD      B,(HL)
        EX      DE,HL
        LD      E,(HL)
        INC     HL
        LD      D,(HL)
        PUSH    DE
        POP     IY
        EXX
        BIT     6,(IX+VBYCHK)   ; test UNKNOWN bit in Y CecHK
        JR      Z,L2FD3
        LD      BC,$0301
        JR      L2FEC

L2FD3:  BIT     4,(IX+VBYCHK)   ; test UNKNOWN bit in Y CJecK
        JR      Z,L2FDE
        LD      BC,$0402
        JR      L2FEC

L2FDE:  LD      H,(IX+$12)
        LD      L,(IX+$11)
        INC     HL
        INC     HL
        LD      A,(HL)
        SLA     A
        LD      B,A
        INC     HL
        LD      C,(HL)
L2FEC:  LD      H,(IX+VBXH)      ; read X location
        LD      L,(IX+VBYH)      ; read Y location
        EXX
L2FF3:  EXX
        BIT     4,(IY+$07)       ; is IY also a Vector Block ??
        JR      NZ,L3064
        BIT     7,(IY+$01)       ; VBSACT bit ??
        JR      Z,L3064
        BIT     6,(IY+$0C)
        JR      Z,L3011
        LD      A,(IY+$02)
        OR      A
        JR      Z,L3064
        LD      DE,$0301
        JR      L3033

L3011:  BIT     4,(IY+$0C)
        JR      Z,L301C
        LD      DE,$0402
        JR      L3033

L301C:  LD      A,(IY+$1B)
        CP      $02
        JR      NZ,L3064
        PUSH    HL
        LD      H,(IY+$12)
        LD      L,(IY+$11)
        INC     HL
        INC     HL
        LD      A,(HL)
        SLA     A
        LD      D,A
        INC     HL
        LD      E,(HL)
        POP     HL
L3033:  LD      A,(IY+$06)      ; read VBXH ??
        EX      AF,AF'
        LD      A,(IY+$0B)      ; read VBYH ??
        EX      DE,HL
        ADD     HL,BC
        EX      DE,HL
        INC     E
        SRA     E
        SUB     L
        JP      M,L304B
        CP      E
        JP      NC,L3064
        JP      L304F

L304B:  ADD     A,E
        JP      M,L3064
L304F:  EX      AF,AF'
        SUB     H
        JP      M,L305B
        CP      D
        JP      NC,L3064
        JP      L305F

L305B:  ADD     A,D
        JP      M,L3064
L305F:  LD      A,$01
        AND     A
        JR      L3065

L3064:  XOR     A
L3065:  EXX
        JR      Z,L3082
        BIT     5,(IX+VBYCHK)   ; test UNKNOWN bit in Y CHecK
        JR      Z,L3072
        SET     2,(IY+$13)
L3072:  BIT     5,(IY+$0C)      ; ?? VBYCHK
        JR      Z,L307C
        SET     2,(IX+$13)
L307C:  SET     5,(IY+$07)      ; ?? VBXCHK
        LD      B,$01
L3082:  INC     HL
        LD      E,(HL)
        INC     HL
        LD      D,(HL)
        PUSH    DE
        POP     IY
        DEC     B
        JP      NZ,L2FF3
        RET

; does if Vector Block in RAM occupied, then check for COLLISION ?? then ??
L308E:  XOR     A
        CP      (IX+VBTIMB)     ; read Vector Block TIMe Base
        RET     Z
        CALL    L24BD           ; do Erase 1 byte from Magic RAM and check for COLLISION
        DEC     (IX+VBTIMB)     ; VB TIMe Base - 1 for ??
        RET     Z
        BIT     5,(IX+VBXCHK)   ; test UNKNOWN bit in Vector Block X CHecK flags
        JR      Z,L30A5
        XOR     A
        LD      (IX+VBTIMB),A   ; clear Vector Block TIMe Base (makes VB empty)
        RET

; then ??
L30A5:  LD      A,$01
        LD      BC,$0000
        CALL    L2E2F
        CALL    L2497           ; write 1 byte to Magic RAM and check for COLLISION ??
        OR      A
        JR      Z,L30BD         ; on no COLLISION
        CALL    L2FA6
        OR      A
        JR      Z,L30BD         ; on ??
        LD      (IX+VBTIMB),$01 ; set TIMe Base to 1 for ??
L30BD:  BIT     VBCLAT,(IX+VBXCHK) ; test Limit ATtained bit in X CHecK
        JR      Z,L30C9
        LD      (IX+VBTIMB),$01 ; set TIMe Base to 1 for ?? again ??
        JR      L30D3

L30C9:  BIT     VBCLAT,(IX+VBYCHK) ; test Limit ATtained bit in Y CHecK
        JR      Z,L30D3
        LD      (IX+VBTIMB),$01 ; set TIMe Base to 1 for ?? again ??
L30D3:  RET

L30D4:  LD      A,(IX+$18)
        CP      $FF
        RET     Z
        BIT     4,(IX+VBXCHK)   ; test UNKNOWN bit in X CHecK
        JR      Z,L30F0
        LD      L,(IX+$0F)
        LD      H,(IX+$10)
        LD      DE,$0009
        ADD     HL,DE
        LD      E,(HL)
        INC     HL
        LD      D,(HL)
        EX      DE,HL
        JR      L310E

L30F0:  BIT     4,(IX+VBYCHK)   ; test UNKNOWN bit in Y CHecK
        JR      Z,L3100
        LD      A,($4F20)
        LD      L,A
        LD      A,($4F21)
        LD      H,A
        JR      L310E

L3100:  LD      L,(IX+$0F)
        LD      H,(IX+$10)
        LD      DE,$0005
        ADD     HL,DE
        LD      E,(HL)
        INC     HL
        LD      D,(HL)
        EX      DE,HL
L310E:  DEC     (IX+$18)
        RET     NZ
        PUSH    HL
        LD      A,(IX+$17)
        INC     A
        JR      Z,L3120
        LD      DE,$0003
        LD      B,A
L311D:  ADD     HL,DE
        DJNZ    L311D
L3120:  LD      B,A
        LD      A,(HL)
        POP     DE
        OR      A
        JR      NZ,L312A
        EX      DE,HL
        LD      A,(HL)
        LD      B,$00
L312A:  LD      (IX+$18),A
        INC     HL
        LD      A,(HL)
        LD      (IX+$11),A
        INC     HL
        LD      A,(HL)
        LD      (IX+$12),A
        LD      (IX+$17),B
        RET
; end of if Vector Block in RAM occupied, then ??

; ??
L313B:  LD      A,($4F78)
        CP      $00
        JP      NZ,L23B1        ; if ?? then to Restore Environment
        LD      A,$01
        LD      ($4F78),A
        XOR     A
        LD      ($4F72),A
        LD      A,($4F75)
        LD      ($4F73),A
        EI
L3153:  LD      A,($4F78)
        CP      $01
        JP      NZ,L3180
        LD      A,($4F72)
        OR      A
        JP      NZ,L3180
        LD      A,($4F73)
        OR      A
        JP      Z,L3180
        LD      HL,L2280        ; point at second table of 2 RAM addresses ??
        CALL    L2236           ; do With HL = L2280 for ??
        LD      A,L
        OR      H
        JR      NZ,L3180        ; if HL then zero $4F78 and
        LD      HL,$4F75
        DEC     (HL)
        LD      HL,$4F73
        DEC     (HL)
        CALL    L22D7           ; do ?? with DE used for IX
        JR      L3153           ; loop for next ??

L3180:  LD      A,$00
        LD      ($4F78),A
        JP      L23B1           ; to Restore Environment

; does ?? explode a BOMB ?? (write current SUPER Bonus is where ??)
L3188:  BIT     4,(IX+VBXCHK)   ; test UNKNOWN bit in X CHecK
        JR      Z,L31BD
        LD      B,(IX+VBTIMB)   ; read TIMe Base
L3191:  DEC     (IX+$19)
        JR      NZ,L31BA
        RES     VBSACT,(IX+VBSTAT) ; clear !! BOMB STatus byte ACTive bit
        BIT     6,(IX+$13)      ; test BOMB for ??
        JR      Z,L31A3
        CALL    L2D15           ; display incremental Super BONUS for destroying a BOMB !!
L31A3:  CALL    L2F80           ; do ?? done TWICE for EXIT Routine ??
        POP     AF
        LD      HL,$4F25
        DEC     (HL)            ; ?? - 1 for ??
        BIT     4,(IX+VBYCHK)   ; test UNKNOWN bit in Y CHwcK
        JR      Z,L31B9
        LD      A,$01
        LD      ($4F24),A       ; ?? set ?? to 1 PLAYER for ??
        JP      L313B           ; to ??

L31B9:  RET

L31BA:  DJNZ    L3191
        RET

L31BD:  BIT     5,(IX+VBXCHK)   ; test UNKNOWN bit in X CHwcK
        RET     Z
        BIT     4,(IX+VBYCHK)   ; test UNKNOWN bit in Y CHwcK
        JR      Z,L31F8
        RES     5,(IX+VBXCHK)   ; clear !! UNKNOWN bit in X CHwcK
        BIT     2,(IX+$13)
        JR      Z,L31E3
        CALL    L2A11           ; TWICE move 7 bytes using MOVE block transfer, then Send 8 SOUND bytes and Read 1 word for ??
        LD      A,($4F22)
        LD      ($4F23),A
        SET     3,(IX+$13)
        RES     2,(IX+$13)
L31E3:  LD      A,($4F23)
        OR      A
        RET     NZ
        CALL    L28E1           ; Move 14 bytes to RAM, then Send 8 SOUND bytes and Read 1 word for ??
        LD      A,$01
        LD      ($4F1E),A       ; 1 for ??
        LD      (IX+VBDYH),$01  ; set Delta Y Hi to 1 for 1.0 speed
        LD      (IX+VBDYL),$00  ; set Delta Y Lo to 0
L31F8:  SET     4,(IX+VBXCHK)   ; set !! UNKNOWN bit in X CHwcK
        RES     VBCREV,(IX+VBYCHK) ; clear !! REVerse delta bit in Y CHwcK
        LD      (IX+$17),$00
        LD      (IX+$18),$01
        LD      A,$18
        LD      (IX+$19),$18
        BIT     2,(IX+VBYCHK)   ; test UNKNOWN bit in Y CHwcK
        JR      Z,L325D
        CALL    L2ABE           ; add $4EFD and PLAYER into HL for ??
        DEC     (HL)
        CALL    L2A58           ; Move 7 bytes to RAM, then Send 8 SOUND bytes and Read 1 word for ??, then Override some SOUND bytes
        BIT     5,(IX+$13)
        JR      Z,L322C
        LD      A,$53
        LD      ($4EF7),A
        LD      A,$10
        LD      ($4EF8),A
        RET

L322C:  LD      A,$07
        LD      ($4EF7),A
        LD      A,$08
        LD      ($4EF8),A
        SET     6,(IX+$13)
        CALL    L2AC4           ; add $4EF9 and PLAYER into HL for ??
        INC     (HL)
        LD      B,(HL)
        LD      A,(HL)
        CP      $01             ; is Dead BOMB count equal to 1 ?
        JR      NZ,L3249
        LD      HL,$0064        ; only 100 points for first BOMB
        JR      L3250

; compute Super BONUS for destroying another BOMB in the same Level !!
L3249:  DEC     B               ; (first one was only 100 points)
        LD      HL,$007D        ; start with 125 points
L324D:  ADD     HL,HL           ; multiply by 2 (to 250, 500, finally 1000 !!)
        DJNZ    L324D
L3250:  PUSH    HL
        LD      (IX+$1F),L      ; write XY location of Dead BOMB
        LD      (IX+$20),H
        CALL    L2D15           ; display incremental Super BONUS for destroying a BOMB !!
        POP     BC
        JR      L3287           ; to ??

L325D:  CALL    L2924           ; Move 7 bytes to RAM, then Send 8 SOUND bytes and Read 1 word for ??
        LD      L,(IX+$0F)
        LD      H,(IX+$10)
        LD      DE,$000B
        ADD     HL,DE
        LD      A,(HL)
        OR      A
        RET     Z
        LD      B,$00
        LD      C,A
        BIT     5,(IX+VBYCHK)   ; test UNKNOWN bit in Y CHwcK
        JR      Z,L327B
        CALL    L2AB3           ; add $4F15 and PLAYER into HL for ??
        JR      L3286           ; to ??

L327B:  LD      (IX+VBDYH),$01  ; set Delta Y to 1.0 speed
        LD      (IX+VBDYL),$00
        CALL    L2AB8           ; add $4F05 and PLAYER into HL for ??
L3286:  DEC     (HL)
L3287:  LD      A,$01
        LD      ($4FA1),A
        CALL    L2AD7           ; read CURRENT Player's SCORE into HL
        ADD     HL,BC
        PUSH    HL
        LD      BC,$C350
        OR      A
        SBC     HL,BC
        JR      NC,L329C
        POP     HL
        JR      L329D

L329C:  POP     BC
L329D:  EX      DE,HL
        LD      (HL),E
        INC     HL
        LD      (HL),D
        BIT     6,(IX+$13)
        RET     Z
        POP     HL
        RET

; Exit Point for ALL code stubs ??
L32A8:  LD      A,($4F24)       ; ?? initalized to NUMber of PLaYers ??
        OR      A
        JR      Z,L32C8         ; if NONE left ?
        BIT     5,(IX+VBXCHK)   ; test UNKNOWN bit in X CHwcK
        JR      NZ,L32C8
        CALL    L2F80           ; do ?? done TWICE for EXIT Routine ??
        LD      A,(IX+$1B)
        CP      $02
        CALL    Z,L2443         ; if ?? draw a Pattern using IX Block information
        RES     VBSACT,(IX+VBSTAT) ; clear STatus byte to make IN-ACTive !!
        LD      HL,$4F25
        DEC     (HL)            ; ?? - 1 for ??
        RET

L32C8:  LD      A,(IX+$1B)
        CP      $02
        JR      NZ,L32D5
        CALL    L2443           ; draw a Pattern using IX Block information
        CALL    L30D4
L32D5:  CALL    L3188           ; do explode a BOMB ??
        LD      L,(IX+$0F)
        LD      H,(IX+$10)
        LD      DE,$0007
        ADD     HL,DE
        LD      E,(HL)
        INC     HL
        LD      D,(HL)
        EX      DE,HL
        LD      A,(IX+VBTIMB)   ; read TIMe Base
        CALL    L2E26
        LD      A,(IX+$1B)
        BIT     VBCLAT,(IX+VBXCHK) ; test X CHecK Limit ATtained
        JR      Z,L3330
        LD      (IX+$19),$03
        LD      B,A
        LD      A,(IX+VBXH)     ; read X location Hi
        CP      $50
        LD      A,B
        JR      NC,L330D
        DEC     A
        JR      NZ,L3307
        LD      A,$03
L3307:  LD      (IX+VBXH),$90   ; write 144 for X location Hi
        JR      L3318

L330D:  INC     A
        CP      $04
        JR      C,L3314
        LD      A,$01
L3314:  LD      (IX+VBXH),$0A   ; write 10 for X location Hi
L3318:  LD      (IX+$1B),A
        LD      A,B
        CP      $02
        JR      NZ,L3330
        LD      E,(IX+VBDXL)    ; read Delta X word
        LD      D,(IX+VBDXH)
        SRA     D               ; DIVide by 2
        RR      E
        LD      (IX+VBDXL),E    ; write Delta X word / 2
        LD      (IX+VBDXH),D
L3330:  LD      A,(IX+$1B)
        CP      $02
        JP      NZ,L2F95        ; if ?? to EXIT Routine for ??
        BIT     4,(IX+VBXCHK)   ; test UNKNOWN bit in X CHwcK
        JR      NZ,L3350
        LD      A,($40CF)
        CP      (IX+VBXH)       ; ComPare to X location Hi
        JR      NC,L334C
        RES     MRFLOP,(IX+VBMR) ; clear !! FLOP bit in Magic Register
        JR      L3350

L334C:  SET     MRFLOP,(IX+VBMR) ; set !! FLOP bit in Magic Register
L3350:  CALL    L2460
        OR      A
        JR      Z,L3360
        CALL    L2FA6
        OR      A
        JR      Z,L3360
        SET     5,(IX+VBXCHK)   ; set !! UNKNOWN bit in X CHwcK
L3360:  JP      L2F95           ; to EXIT Routine for ??
; end of Exit Point for ALL code stubs routine

; DIRTs 1 through 6 (Color 3 would be a leftover WHITE)
L3363:  DB      $01             ; DIRT 1
        DB      $00             ; . . . . BLACK and ...
        DB      $00             ; . . . .
        DB      $00             ; . . . .
        DB      $AA             ; 2 2 2 2 .. aka TAN
        DB      $AA             ; 2 2 2 2

L3369:  DB      $02             ; DIRT 2
        DB      $00             ; . . . .
        DB      $00             ; . . . .
        DB      $00             ; . . . .
        DB      $AA             ; 2 2 2 2
        DB      $55             ; 1 1 1 1 ... aka BROWN

L336F:  DB      $03             ; DIRT 3
        DB      $00             ; . . . .
        DB      $00             ; . . . .
        DB      $00             ; . . . .
        DB      $55             ; 1 1 1 1
        DB      $55             ; 1 1 1 1

L3375:  DB      $04             ; DIRT 4
        DB      $00             ; . . . .
        DB      $00             ; . . . .
        DB      $55             ; 1 1 1 1
        DB      $55             ; 1 1 1 1
        DB      $55             ; 1 1 1 1

L337B:  DB      $05             ; DIRT 5
        DB      $00             ; . . . .
        DB      $55             ; 1 1 1 1
        DB      $55             ; 1 1 1 1
        DB      $55             ; 1 1 1 1
        DB      $55             ; 1 1 1 1

L3381:  DB      $06             ; DIRT 6
        DB      $55             ; 1 1 1 1
        DB      $55             ; 1 1 1 1
        DB      $55             ; 1 1 1 1
        DB      $55             ; 1 1 1 1
        DB      $55             ; 1 1 1 1

; search for BROWN as DIRT (B = 5 through 1 for depth, or B = 0 for none)
L3387:  LD      B,$05           ; 5 for DIRT depth
        LD      DE,$0028        ; 40 for BYTEPL
        LD      A,$55           ; for BROWNs
L338E:  CP      (HL)
        RET     Z               ; bail if BROWN found
        ADD     HL,DE
        DJNZ    L338E
        RET

; display Column of DIRT
L3394:  LD      A,($4F24)       ; ?? initalized to NUMber of PLaYers ??
        OR      A
        RET     NZ              ; bail if ANY left ?
        LD      A,($4F27)
        BIT     7,A
        PUSH    AF
        LD      A,($4EF6)       ; +/- SPEED ??
        JR      Z,L33C3
        BIT     7,A             ; direction of flight
        JR      NZ,L33B2
        LD      HL,$4BDF        ; NORMEM + 75 * BYTEPL + 39 (right side)
        CALL    L3387           ; search for BROWN DIRT
        LD      A,B
        INC     A
        JR      L33B5           ; A = 6 thru 2 (or 1 for not found)

L33B2:  LD      A,($4F2D)       ; A = ??
L33B5:  LD      BC,$00C7        ; 199 for 5 * BYTEPL - 1 (byte count)
        LD      DE,$4BB8        ; NORMEM + 75 * BYTEPL (left side)
        LD      HL,$4BB9        ; + 1
        LDIR
        LD      C,A
        JR      L33E0           ; to continue ??

; on NO movement ??
L33C3:  BIT     7,A             ; ?? +/- ZERO ??
        JR      Z,L33D1
        LD      HL,$4BB8        ; NORMEM + 75 * BYTEPL (left side)
        CALL    L3387           ; search for BROWN as DIRT
        LD      A,B
        INC     A
        JR      L33D4           ; A = 6 thru 2 (or 1 for not found)

L33D1:  LD      A,($4F2C)       ; A = ??
L33D4:  LD      BC,$00C7        ; 199 for 5 * BYTEPL - 1 (byte count)
        LD      DE,$4C7F        ; NORMEM + 79 * BYTEPL + 39 (right side)
        LD      HL,$4C7E        ; - 1
        LDDR
        LD      C,A
; continue
L33E0:  EXX
        SYSSUK  RANGED          ; UPI RANGED random number
        DB      $00             ; ... NO Cutoff
        ;
        EXX
        LD      HL,$4EF5
        LD      DE,L3369        ; point at DIRT 2
        DEC     C
        JR      NZ,L33FB
        CP      $C0
        JR      C,L33F7
        LD      DE,L3363        ; point at DIRT 1
        JR      L33F9

L33F7:  LD      (HL),$01
L33F9:  JR      L3468

L33FB:  DEC     C
        JR      NZ,L3414
        BIT     0,(HL)
        JR      Z,L3407
        LD      DE,L336F        ; point at DIRT 3
        JR      L3412

L3407:  CP      $80
        JR      NC,L3410
        LD      DE,L3363        ; point at DIRT 1 again
        JR      L3412

L3410:  LD      (HL),$01
L3412:  JR      L3468

L3414:  DEC     C
        JR      NZ,L342B
        BIT     0,(HL)
        JR      Z,L3420
        LD      DE,L3375        ; point at DIRT 4
        JR      L3429

L3420:  CP      $80
        JR      C,L3429
        LD      DE,L3375        ; point at DIRT 4 again
        LD      (HL),$01
L3429:  JR      L3468

L342B:  DEC     C
        JR      NZ,L3447
        BIT     0,(HL)
        JR      Z,L3442
        CP      $C0
        JR      NC,L343B
        LD      DE,L337B        ; point at DIRT 5
        JR      L3440

L343B:  LD      DE,L336F        ; point at DIRT 3 again
        LD      (HL),$00
L3440:  JR      L3445

L3442:  LD      DE,L336F        ; point at DIRT 3 again again
L3445:  JR      L3468

L3447:  DEC     C
        JR      NZ,L3463
        BIT     0,(HL)
        JR      Z,L345E
        CP      $C0
        JR      NC,L3457
        LD      DE,L3381        ; point at DIRT 6
        JR      L345C

L3457:  LD      DE,L3375        ; point at DIRT 4 #3
        LD      (HL),$00
L345C:  JR      L3461

L345E:  LD      DE,L3375        ; point at DIRT 4 #4
L3461:  JR      L3468

L3463:  LD      DE,L337B        ; point at DIRT 5 again
        LD      (HL),$00
L3468:  EX      DE,HL
        POP     AF
        LD      ($4EF6),A
        JR      Z,L3478
        LD      A,(HL)
        LD      ($4F2D),A
        LD      DE,$4BB7        ; NORMEM + 74 * BYTEPL + 39 (right side)
        JR      L347F           ; to write a column of 5 bytes

L3478:  LD      A,(HL)
        LD      ($4F2C),A
        LD      DE,$4B90        ; NORMEM + 74 * BYTEPL (left side)
L347F:  LD      B,$05           ; for a column of 5 DIRT bytes
L3481:  PUSH    BC
        LD      BC,$0028        ; 40 for next line down
        INC     HL
        LD      A,(HL)
        EX      DE,HL
        ADD     HL,BC
        LD      (HL),A
        EX      DE,HL
        POP     BC
        DJNZ    L3481
        RET
; end of Display some DIRT

; Very BOTTOM of Screen Interrupt Routine !! Vector poked into RAM at $4F82
; does a lot of MOVE and DRAW while VERTical RETrace, triggered at Scanline 179
L348F:  PUSH    AF
        PUSH    BC
        PUSH    DE
        PUSH    HL
        EXX
        EX      AF,AF'
        PUSH    AF
        PUSH    BC
        PUSH    DE
        PUSH    HL
        PUSH    IY
        PUSH    IX
        LD      A,($4F1D)       ; read Color BAR blanking (if set NOT zero)
        OR      A
        JR      NZ,L34A9
        LD      A,$F2           ; Dark Blue for both Background colors
        OUT     (COL0L),A
        OUT     (COL0R),A
L34A9:  LD      A,($4F7C)       ; TOP of Screen Interrupt Screen Line (always 240 ??)
        OUT     (INLIN),A       ; Port $0F (NOT $0E), INterrupt LINe Register
        LD      A,$4F           ; High Order Byte Address of Interrupt Vector
        LD      I,A             ; Load Interrupt Vector Register
        LD      A,$88           ; Get Low Order Byte Address
        OUT     (INFBK),A       ; Port $0D, INterrupt FeedBacK Register for $4F88
        LD      A,($4F79)
        CP      $01
        JR      NZ,L34C2
        LD      A,$02
        LD      ($4F79),A
L34C2:  LD      A,($4FB1)
        OR      A
        JR      Z,L34D4         ; if zero, Move Player's Ship ?? ...
        LD      DE,L34D4        ; ... else save routine in $4FAF
        LD      HL,$4FAF
        LD      (HL),E
        INC     HL
        LD      (HL),D
        JP      L23B1           ; to Restore Environment

; Move PLAYER'S SHIP ?? (and Scroll EVERYTHING ELSE ??) routine
L34D4:  EI
        CALL    L2081           ; do Clear bytes $4FB0 and $4FB1
        LD      HL,$4F2A        ; ?? initalized to NUMber of PLaYers ??
        DEC     (HL)
        JP      NZ,L36C8        ; anybody left ?
        LD      (HL),$03        ; write 3 PLAYERS for ??
        LD      IX,$40C9        ; point to Player's Ship VECTOR Block !!
        BIT     VBSACT,(IX+VBSTAT) ; test Player's Ship STatus byte
        JP      Z,L36C8         ; is it inactive ?
        CALL    L2443           ; no, draw a Pattern using IX Block information
        LD      A,($4F24)       ; ?? initalized to NUMber of PLaYers ??
        OR      A
        JR      Z,L3509         ; if NONE left ?
        BIT     4,(IX+VBXCHK)   ; else check UNKNOWN bit in X CHwcK
        JR      NZ,L3509
        CALL    L2F80           ; do ?? done TWICE for EXIT Routine ??
        RES     VBSACT,(IX+VBSTAT) ; mark Player's Ship STatus byte IN-ACTive !!
        LD      HL,$4F25
        DEC     (HL)            ; ?? - 1 for ??
        JP      L313B           ; to ??

; ?? on Moving Left or Right ??
L3509:  CALL    L3188           ; do explode a BOMB ??
        BIT     4,(IX+VBXCHK)   ; test UNKNOWN bit in X CHwcK ?
        JP      NZ,L3692
        LD      HL,$4F28        ; no, positive (moving Right ??)
        CALL    L2AD0           ; do Set C for Current INPUT Port
        IN      A,(C)           ; read JoyStick for Current Player
        PUSH    AF
        AND     $0F
        CP      (HL)            ; any change made ?
        JR      Z,L359D
        LD      DE,$0000        ; yes, start with NULL
        BIT     0,A             ; JY Up ?
        JR      Z,L352B
        LD      DE,$FE00        ; yes, (NOT a RAM location !!) for -2.0 Up
L352B:  BIT     1,A             ; JY Down ?
        JR      Z,L3532
        LD      DE,$0200        ; point at $0200 (NOT STIMER !!) for 2.0 Down
L3532:  LD      (IX+VBDYH),D    ; either way, write the word for Delta Y
        LD      (IX+VBDYL),E
        LD      C,A
        LD      A,($40C9+$13)   ; read PLAYER'S SHIP VB UNKNOWN byte at $40DC ??
        BIT     0,A             ; JX Up ? NO, VB LEFT ??
        JR      NZ,L355F
        LD      DE,$FE80        ; for -1.5 X speed Left (NOT -384 !!)
        BIT     3,C             ; JX Right ?
        LD      A,$00           ; start with 0 byte
        JR      Z,L3555
        LD      DE,$0200        ; for 2.0 X speed Right (NOT game Seconds TIMER)
        BIT     3,(HL)
        JR      NZ,L3553
        LD      A,$01           ; now a 1 byte
        LD      B,A
L3553:  JR      L355D

L3555:  BIT     3,(HL)
        JR      Z,L355D
        LD      B,$00
        LD      A,$01           ; again a 1 byte
L355D:  JR      L357C

L355F:  LD      DE,$0180        ; for 1.5 X speed Right
        BIT     2,C             ; JX Left ?
        LD      A,$00           ; again a 0 byte
        JR      Z,L3574
        LD      DE,$FE00        ; for -2.0 X speed Left
        BIT     2,(HL)
        JR      NZ,L3572
        LD      A,$01           ; again a 1 byte
        LD      B,A
L3572:  JR      L357C

L3574:  BIT     2,(HL)
        JR      Z,L357C
        LD      B,$00
        LD      A,$01           ; again a 1 byte
L357C:  OR      A
        JR      Z,L359D
        SET     3,(IX+$13)
        BIT     1,(IX+$13)
        JR      NZ,L358F
        LD      (IX+VBDXH),D     ; write for Delta X word
        LD      (IX+VBDXL),E
L358F:  LD      A,B
        OR      A
        JR      Z,L3599
        SET     4,(IX+$13)
        JR      L359D

L3599:  RES     4,(IX+$13)
L359D:  LD      HL,$4F29
        POP     AF
        LD      ($4F28),A        ; write JoyStick for Current Player to ??
        BIT     4,A
        JR      Z,L35B3
        XOR     A                ; on TRIGGER pulled
        CP      (HL)
        JR      NZ,L35B1
        LD      (HL),$01
        CALL    L2EAA           ; do Look for Empty Vector Block then ??
L35B1:  JR      L35B5

L35B3:  LD      (HL),$00
L35B5:  LD      HL,$40C9+$13    ; point at PLAYER'S SHIP UNKNOWN byte at $40DC ??
        BIT     1,(HL)
        JR      Z,L35E1
        LD      C,(IX+VBXH)     ; read Player's Ship X
        BIT     0,(HL)
        JR      Z,L35D3
        LD      A,$64           ; 100 for Right edge
        CP      C
        JR      NC,L35D1        ; not at ?
        RES     1,(HL)
        LD      ($4F2E),A       ; set Player's Ship X Left limit ??
        XOR     A
        LD      ($4F28),A       ; and stop ??
L35D1:  JR      L35E1

L35D3:  LD      A,$3C           ; at Left edge ?
        CP      C
        JR      C,L35E1
        RES     1,(HL)
        LD      ($4F2F),A       ; set Player's Ship X Right limit to 60 ??
        XOR     A
        LD      ($4F28),A       ; and stop ??
L35E1:  LD      A,($4F28)
        LD      C,A
        XOR     A
        BIT     0,(HL)
        JR      NZ,L35FA
        BIT     2,C
        JR      Z,L35F8
        SET     0,(HL)
        SET     MRFLOP,(IX+VBMR) ; set VB Magic Register FLOP bit = 1
        LD      DE,$0200         ; for 2.0 X speed Right (NOT point at STIMER !!)
        INC     A
L35F8:  JR      L3608

L35FA:  BIT     3,C
        JR      Z,L3608
        RES     0,(HL)
        RES     MRFLOP,(IX+VBMR) ; clear VB Magic Register FLOP bit = 0
        LD      DE,$FE00         ; for -2.0 X speed Left
        INC     A
L3608:  OR      A
        JR      Z,L361F
        LD      (IX+VBDXL),E    ; if moving, write Delta X
        LD      (IX+VBDXH),D
        SET     1,(HL)
        XOR     A
        LD      ($4F28),A
        LD      HL,$4F2E        ; point at PLAYER'S Vector Limit Table in RAM
        LD      (HL),$28        ; 40 for Left
        INC     HL
        LD      (HL),$78        ; 120 for Right
L361F:  LD      HL,$4F23
        LD      A,(HL)
        OR      A
        JR      Z,L3643
        DEC     (HL)
        JR      NZ,L3638
        SET     3,(IX+$13)
        XOR     A
        BIT     4,(IX+$13)
        JR      Z,L3635
        INC     A
L3635:  CALL    L29F0           ; to Clear ?? address, then Zero $4F9E ?? then ?? and to ($4F9F) then Select ?? routine by A ?? and on to ?? Routine
L3638:  CP      $20
        JR      NZ,L3643
        SET     3,(IX+$13)
        CALL    L29D8           ; Move 7 bytes to RAM, then Send 8 SOUND bytes and Read 1 word for ??, then Read another word for ??
L3643:  BIT     3,(IX+$13)
        JR      Z,L3692         ; if X Speed ?? Negative ?
        LD      DE,$0000
        RES     3,(IX+$13)
        LD      A,($4F23)
        OR      A
        JR      Z,L3662
        CP      $20
        JR      NC,L365F
        LD      DE,$0004
        JR      L3662

L365F:  LD      DE,$0002
L3662:  BIT     4,(IX+$13)
        JR      Z,L366F
        LD      C,$01
        LD      HL,L2841        ; Animation table for 1 Player's Ship (then 4 above)
        JR      L3674

L366F:  LD      C,$00
        LD      HL,L2862        ; point at Table of 3 Animation tables for Player's Ships
L3674:  ADD     HL,DE
        LD      A,($4F23)
        OR      A
        JR      NZ,L3681
        PUSH    HL
        LD      A,C
        CALL    L299D           ; select Send 8 SOUND bytes routine #1 or routine #2 by A ??
        POP     HL
L3681:  LD      A,(HL)
        LD      ($4F20),A
        INC     HL
        LD      A,(HL)
        LD      ($4F21),A
        LD      (IX+$18),$01
        LD      (IX+$17),$00
; ?? on Moving Left ??
L3692:  CALL    L30D4
        LD      B,$01
        EXX
        LD      L,(IX+$0F)
        LD      H,(IX+$10)
        LD      DE,$0007
        ADD     HL,DE
        LD      E,(HL)
        INC     HL
        LD      D,(HL)
        PUSH    DE
        POP     IY
        LD      A,$01
        LD      BC,$0000
        CALL    L2E2F
        CALL    L2460
        OR      A
        JR      Z,L36C5
        LD      B,$0A
        LD      HL,L2A64        ; point at 10-word RAM table of 31-byte VECTOR Blocks
        CALL    L2FA6
        OR      A
        JR      Z,L36C5
        SET     5,(IX+VBXCHK)   ; set UNKNOWN bit in X CHecK
L36C5:  CALL    L2F95           ; do EXIT Routine for ??
; ?? on NO MOVE Player's Ship ??
L36C8:  LD      HL,$4EF4        ; ?? initalized to NUMber of PLaYers ??
        DEC     (HL)
        JR      NZ,L36ED        ; any body left ?
        LD      (HL),$02
        LD      IY,L2E94        ; point to 2-bytes to copy ?? but why ??
        LD      IX,$4063        ; base Vector Block
        LD      B,$06           ; BLOCK Count
        CALL    L2081           ; do Clear bytes $4FB0 and $4FB1
; does ?? for (up to 6) occupied Vector Blocks starting at $4063
L36DD:  PUSH    BC
        PUSH    IY
        CALL    L308E           ; do if Vector Block in RAM occupied, then check for COLLISION ?? then ??
        POP     IY
        LD      DE,$0011        ; 17 for quantum
        ADD     IX,DE           ; for next Block
        POP     BC
        DJNZ    L36DD           ; loop for next Vector Block
; then ??
L36ED:  CALL    L208E           ; do Clear byte $4FB1 and check $4FB0
        LD      A,($4F2A)       ; ?? initalized to NUMber of PLaYers ??
        CP      $03
        JP      NZ,L313B        ; if ?? to ??
        LD      A,($40C9+$13)   ; read PLAYER'S SHIP VB UNKNOWN byte at $40DC ??
        LD      DE,$0000
        LD      HL,($4F26)
        BIT     7,H
        JR      Z,L3717
        BIT     0,A
        JR      Z,L3715
        BIT     4,A
        JR      Z,L3712
        LD      DE,$0040
        JR      L3715

L3712:  LD      DE,$0010
L3715:  JR      L3727

L3717:  BIT     0,A
        JR      NZ,L3727
        BIT     4,A
        JR      Z,L3724
        LD      DE,$FFC0
        JR      L3727

L3724:  LD      DE,$FFF0
L3727:  LD      A,E
        OR      A
        JR      Z,L372E
        ADD     HL,DE
        JR      L3768

L372E:  BIT     7,H
        PUSH    AF
        CALL    NZ,L2035
        LD      A,($40C9+$13)   ; read PLAYER'S SHIP VB UNKNOWN byte at $40DC ??
        BIT     4,A
        JR      Z,L3742
        LD      DE,$0040
        LD      B,$02
        JR      L3747

L3742:  LD      DE,$0010
        LD      B,$01
L3747:  LD      A,E
        NEG
        LD      C,A
        LD      A,B
        LD      B,$FF
        CP      H
        JR      Z,L375B
        JR      C,L375B
        ADD     HL,DE
        CP      H
        JR      NZ,L3759
        LD      L,$00
L3759:  JR      L3764

L375B:  ADD     HL,BC
        CP      H
        JR      Z,L3764
        JR      C,L3764
        LD      H,A
        LD      L,$00
L3764:  POP     AF
        CALL    NZ,L2035
L3768:  LD      ($4F26),HL
        LD      A,H
        BIT     7,A
        JR      NZ,L3772
        NEG
L3772:  ADD     A,$03
        LD      C,A
        LD      HL,$4F2B        ; ?? initalized to NUMber of PLaYers ??
        DEC     (HL)
        JP      NZ,L313B        ; if any one left ? to ??
        LD      (HL),C
        CALL    L3394           ; do Display Column of DIRT
        JP      L313B           ; to ??
; end of Move Player's Ship ?? routine

; Very BOTTOM of PLAYFIELD Interrupt Routine !! Vector poked into RAM at $4F8A
; Sets DIRT Colors (Background Color 0 stays BLACK) triggered at Scanline 147
L3783:  PUSH    AF
        LD      A,$9F           ; 159 for INterrupt LINe
        OUT     (INLIN),A
        LD      A,$4F
        LD      I,A
        LD      A,$84
        OUT     (INFBK),A       ; set INterrupt FeedBacK for $4F84 in RAM
        LD      A,$72           ; Dark BROWN for BOTH Left & Right Color 1
        OUT     (COL1L),A
        OUT     (COL1R),A
        LD      A,$75           ; Lighter TAN for BOTH sides Color 2
        OUT     (COL2L),A
        OUT     (COL2R),A
        LD      A,$07           ; WHITE for BOTH Color 3 (not a Dirt color !!)
        OUT     (COL3L),A
        OUT     (COL3R),A
        POP     AF
        EI
        RET

; CONTROL Panel (with RADAR Screen) Interrupt Routine !! Vector poked into RAM at $4F84
; Color band below Playfield (Color 3 stays WHITE) triggered at Scanline 159
L37A5:  PUSH    AF
        LD      A,$B3           ; 179 for INterrupt LINe
        OUT     (INLIN),A
        LD      A,$4F
        LD      I,A
        LD      A,$82
        OUT     (INFBK),A       ; set INterrupt FeedBacK for $4F82 in RAM
        LD      A,($4F1D)
        OR      A               ; test Color BAR blanking NOT zero ?
        JR      NZ,L37CE
        LD      A,$A3           ; Medium GREEN for LEFT Color 1
        OUT     (COL1L),A
        LD      A,$77           ; Light YELLOW for RIGHT Color 1
        OUT     (COL1R),A
        LD      A,$62           ; Dark RED for BOTH Background
        OUT     (COL0L),A
        OUT     (COL0R),A
        LD      A,$F0           ; Darkest BLUE for RIGHT Color 2
        OUT     (COL2R),A
        LD      A,$A0           ; Darkest GREEN for LEFT Color 2
        OUT     (COL2L),A
L37CE:  POP     AF
        EI
        RET

; (TOP Border into) TOP of Screen Interrupt Routine !! Vector poked into RAM at $4F88
; BLACK band (to hide RAM usage up there !!) triggered at Scanline 240 offscreen
L37D1:  PUSH    AF
        LD      A,$18           ; 24 for INterrupt LINe
        OUT     (INLIN),A
        LD      A,$4F
        LD      I,A
        LD      A,$80
        OUT     (INFBK),A       ; set INterrupt FeedBacK for $4F80 in RAM
        LD      A,($4EF8)       ; pre-set to $10 or $08
        OR      A
        JR      Z,L37ED
        DEC     A               ; count-down to 0 while either
        LD      ($4EF8),A
        JR      Z,L37ED
        LD      A,($4EF7)       ; ?? Dark RED or WHITE for eXPLOsion ??
L37ED:  OUT     (COL0R),A       ; Bang the palettes together
        OUT     (COL1R),A
        OUT     (COL2R),A
        OUT     (COL3R),A
        OUT     (COL0L),A
        OUT     (COL1L),A
        OUT     (COL2L),A
        OUT     (COL3L),A
        POP     AF
        EI
        RET

; PLAYFIELD (into STARTING & INITIAL ??) Interrupt Routine !! Vector poked into RAM at $4F80
; Color band for SHIPS (Background Color 0 stays BLACK !!) triggered at Scanline 24
L3800:  PUSH    AF
        LD      A,$6C           ; 108 for INterrupt LINe
        OUT     (INLIN),A
        LD      A,$4F
        LD      I,A
        LD      A,$7E
        OUT     (INFBK),A       ; set INterrupt FeedBacK for $4F7E in RAM
        LD      A,($4EF8)
        OR      A
        JR      NZ,L3817
        OUT     (COL0L),A       ; BLACK for BOTH Background
        OUT     (COL0R),A
L3817:  LD      A,$52           ; Dark RED for BOTH Color 1
        OUT     (COL1L),A
        OUT     (COL1R),A
        LD      A,$F4
        OUT     (COL2L),A       ; BLUE for BOTH Color 2
        OUT     (COL2R),A
        LD      A,$76
        OUT     (COL3L),A       ; YELLOW for BOTH Color 3
        OUT     (COL3R),A
        POP     AF
        EI
        RET

; L382C: NOT label ??
        DB      $00
        DB      $00
        DB      $01
        DB      $01
        DB      $00

; 31-bytes to copy for VECTOR Block template to ?? in RAM
L3831:  DB      $20             ; $00 - use as (IX+VBMR) for MAGIC Register = XOR
        DB      $80             ; $01 - (IX+VBSTAT) byte for STATus byte, with:
                                        ; note: bit 6 = VBBLNK for BLaNK bit = 0,
                                        ; and bit 7 = VBSACT for ACTive bit = 1
        DB      $01             ; $02 - (IX+VBTIMB) byte for TIMe Base = 1
        DB      $00             ; $03 - (IX+VBDXL) byte for Delta for X Low = 0
        DB      $00             ; $04 - (IX+VBDXH) byte for Delta for X Hi = 0
        DB      $00             ; $05 - (IX+VBXL) byte for X coord Low = 0
        DB      $20             ; $06 - (IX+VBXH) byte for X coord Hi = 32 from Left
        DB      $05             ; $07 - (IX+VBXCHK) byte for X CHecK flags, with:
                                        ; note: bit 0 = VBCLMT for LiMiT bit = 1,
                                        ; bit 1 = VBCREV for REVerse delta on limit attain bit = 0,
                                        ; and bit 2 = VBCLAT for X Limit ATtained bit = 1
        DB      $00             ; $08 - (IX+VBDYL) byte for Delta for Y Low = 0
        DB      $00             ; $09 - (IX+VBDYH) byte for Delta for Y Hi = 0
        DB      $00             ; $0A - (IX+VBYL) byte for Y coord Low = 0
        DB      $31             ; $0B - (IX+VBYH) byte for Y coord Hi = 49 from Top
        DB      $00             ; $0C - (IX+VBYCHK) byte for Y CHecK flags, preset to 1, 3 or 5
                                        ; note: bit 0 = VBCLMT for LiMiT bit (probably = 1),
                                        ; bit 1 = VBCREV for REVerse delta on limit attain bit,
                                        ; and bit 2 = VBCLAT for Y Limit ATtained bit
        DB      $00             ; $0D - (IX+VBOAL) byte for Old Address Low = 0
        DB      $00             ; $0E - (IX+VBOAH) byte for Old (Blanking) Address Hi = 0
        DB      $00             ; $0F - ?? word ?? for pointer to data table in ROM ??
        DB      $00             ; $10 - ?? for ?? part 2
        DB      $2C             ; $11 - ?? word ?? for L382C ??
        DB      $38             ; $12 - ?? for ?? ditto
        DB      $00             ; $13 - ?? for ??
        DB      $00             ; $14 - ?? for ??
        DB      $FF             ; $15 - ?? for ??
        DB      $02             ; $16 - ?? for ??
        DB      $00             ; $17 - ?? for ??
        DB      $01             ; $18 - ?? for ??
        DB      $20             ; $19 - ?? for ??
        DB      $01             ; $1A - ?? for ??
        DB      $03             ; $1B - ?? for ??
        DB      $00             ; $1C - ?? preset to $40, $80 or $C0 for ??
        DB      $00             ; $1D - ?? for ??
        DB      $00             ; $1E - ?? for ??

; copy 31 bytes from L3831 to DE (was in IX ??) with IX = destination:
; (for five or ?? blocks) $40E8, $4021 (and $4042), ??, ?? or $40C9 for ?? in RAM ?? then ??
; with HL = L38C5, L3961, L3AD2 (and L3AC2 and L3AB6), L3BA0 (and L3B94) or L3919 for data table !!
; with BC = $A3C0, $0540, $8380, $8380 again or $91C0 for ?? NOT RAM !!
L3850:  CALL    L2081           ; do Clear bytes $4FB0 and $4FB1
        PUSH    HL
        PUSH    BC
        PUSH    IX
        POP     DE
        LD      C,$1F           ; 31 for Byte Count !!
        LD      HL,L3831        ; point to VECTOR Block template
        LD      B,$00
        SYSTEM  MOVE            ; UPI MOVE block transfer
        ;
        POP     BC              ; i.e. $91C0
        LD      (IX+VBYCHK),B   ; 10010001B into ?? and bit 0 = Y LiMiT bit
        LD      (IX+$1C),C      ; and 11000000B into ??
        POP     HL
        LD      (IX+$0F),L      ; i.e. pointer to L3919 into ??
        LD      (IX+$10),H
        BIT     4,(IX+VBYCHK)   ; test UNKNOWN bit ?? (set above ??)
        JR      Z,L387A
        LD      A,$02
        LD      (IX+$1B),A      ; 2 for ?? into ??
L387A:  LD      HL,$4F25
        INC     (HL)            ; ?? + 1 for ??
        CALL    L208E           ; do Clear byte $4FB1 and check $4FB0
        BIT     4,(IX+VBYCHK)   ; re-test UNKNOWN bit ?? (set above ??)
        JR      NZ,L3891        ; RETurn if set ??
        LD      A,($4FAE)       ; else ??
        DEC     A
        LD      (IX+$14),A
        CALL    L2284           ; do ??
L3891:  RET

;  Fill 16 bytes of RAM at $4011-$4020 with 0's
L3892:  SYSSUK  FILL            ; UPI FILL memory with data
        DW      $4011           ; ... Memory Address = 16401
        DW      $0010           ; ... Byte Count = 16
        DB      $00             ; ... Data = 0
        ;
        RET

; look for Positive entry in (RAM table) and if Found then set IX to it
; with HL = L3ADE or L3BAC, B = 1 thru 3 (or 4) as count
L389A:  XOR     A
L389B:  LD      E,(HL)          ; read (another) word
        INC     HL
        LD      D,(HL)
        INC     HL              ; point at next entry
        EX      DE,HL
        INC     HL              ; word + 1
        BIT     7,(HL)          ; check Sign bit for ??
        JR      NZ,L38AC        ; if Negative found, skip it
        DEC     HL              ; else set IX to word - 1
        PUSH    HL
        POP     IX
        INC     A               ; set Found flag
        LD      B,$01           ; to end loop
L38AC:  EX      DE,HL           ; HL = next entry
        DJNZ    L389B           ; loop until Found (or Count = 0)
        RET

; code stub for ENERGY STAR does ??
L38B0:  BIT     5,(IX+VBXCHK)   ; test UNKNOWN bit in X CHecK
        JP      NZ,L32A8        ; if ?? to exit point for code stub
        LD      A,($4F24)       ; ?? initalized to NUMber of PLaYers ??
        OR      A
        JP      Z,L32A8         ; if NONE left, to exit point for code stub
        LD      HL,$4017
        INC     (HL)
        JP      L32A8           ; to exit point for code stub
 ; end of code stub for ENERGY STAR

; MIXED data table for ENERGY STAR
L38C5:  DW      L2A78           ; 4-word RAM table of 17-byte VECTOR Blocks
        DB      $01             ; 1 for ONLY check for Collision with PLAYER's Ship
        DW      L38B0           ; is code stub for ENERGY STAR
        DW      L2590           ; Animation table for 3 Energy Stars
        DW      L2A80           ; 4-bytes of Vector Limit Table
        DW      L2533           ; (NOT !!) Animation table for 2 BOMB-Explosions
        DB      $C8             ; 200 POINTS for using it !!
; end of data table for ENERGY STAR

; Vectored C/T-3 routine does ??
L38D1:  LD      A,($4F24)       ; ?? initalized to NUMber of PLaYers ??
        OR      A
        JR      NZ,L3910        ; if ANY left ?
        LD      IX,$40E8
        BIT     VBSACT,(IX+VBSTAT) ; test ACTive bit of ENERGY STAR STATus
        JR      NZ,L3910
        LD      HL,$4017
        LD      A,(HL)
        OR      A
        JR      Z,L3910
        DEC     (HL)
        LD      HL,L38C5        ; point at ?? table for ENERGY STAR
        LD      BC,$A3C0
        CALL    L3850           ; do Copy VECTOR Block template and ?? to RAM
        SYSSUK  RANGED          ; UPI RANGED random number
        DB      $80             ; ... Cutoff = 128
        ;
        ADD     A,$14
        LD      (IX+VBXH),A     ; for 20 to 146 X location Hi
        AND     $1F
        ADD     A,$18
        LD      (IX+VBYH),A     ; for 44 to 55 or back to 40 ?? for Y location
        AND     $01
        INC     A
        CP      $02
        JR      NZ,L3909
        INC     A
L3909:  LD      (IX+$1B),A
        SET     VBSACT,(IX+VBSTAT) ; set ACTive bit of ENERGY STAR STATus = 1
L3910:  LD      DE,$0803
        CALL    L20CB           ; do Set Counter Timer 3 to an 8
        JP      L38D1           ; loop on Vectored C/T-3 routine
; end of Vectored C/T-3 routine

; MIXED data table for PLAYER'S SHIP copied to $40C9 in RAM !!
L3919:  DW      L2A64           ; 10-word RAM table of 31-byte VECTOR Blocks
        DB      $0A             ; 10 for ALL 10 to check for Collision with
        DW      $0000           ; is L0000 RESET !!
        DW      L2780           ; Animation table for 2 Player's Ships (With Rocket Exhaust)
        DW      $4F2E           ; PLAYER'S SHIP Vector Limit Table in RAM
        DW      L2731           ; Animation table for 4 Ship-Explosions
        DB      $00             ; 0 POINTS for shooting yourself !!
; end of data table for PLAYER'S SHIP

; code stub for BOMBS does ??
L3925:  BIT     6,(IX+$13)
        JR      Z,L392E
        JP      L3188           ; do explode a BOMB ??

L392E:  LD      A,($4F24)       ; ?? initalized to NUMber of PLaYers ??
        OR      A
        JR      Z,L3941         ; if NONE left ?
        BIT     5,(IX+VBXCHK)   ; test UNKNOWN bit in X CHecK
        JR      NZ,L3941
        LD      HL,$4018
        INC     (HL)
        JP      L32A8           ; to exit point for code stub

L3941:  LD      A,($4F1E)
        OR      A
        JP      NZ,L32A8        ; if ?? to exit point for code stub
        BIT     VBCLAT,(IX+VBYCHK) ; test UNKNOWN bit in Y CHecK
        JP      Z,L32A8         ; if ?? to exit point for code stub
        BIT     5,(IX+$13)
        JP      NZ,L32A8        ; if ?? to exit point for code stub
        SET     5,(IX+$13)
        SET     5,(IX+VBXCHK)   ; set UNKNOWN bit in X CHecK
        JP      L32A8           ; to exit point for code stub
; end of code stub for BOMBS

; MIXED data table for BOMBS
L3961:  DW      L2A78           ; 4-word RAM table of 17-byte VECTOR Blocks again
        DB      $04             ; 4 for ??
        DW      L3925           ; is code stub for BOMBS
        DW      L24FB           ; Animation table for 2 Bombs
        DW      L2A80           ; 4-bytes of Vector Limit Table again
        DW      L2731           ; (WRONG !!) Animation table for 4 SHIP-Explosions
                                ; 58 below for ?? variable POINTS for shooting
; end of data table for BOMBS

; Vectored C/T-6 routine does ??
L396C:  LD      A,($4F24)       ; ?? initalized to NUMber of PLaYers ??
        OR      A
        JR      NZ,L39C9        ; if ANY left ?
        LD      IX,$4042        ; point to BOMBS VECTOR Block #1
        BIT     VBSACT,(IX+VBSTAT) ; test ACTive bit of Vector Block STATus
        JR      Z,L3984
        LD      IX,$4021        ; point to BOMBS VECTOR Block #2
        BIT     VBSACT,(IX+VBSTAT) ; test ACTive bit of Vector Block STATus again
L3984:  JR      NZ,L39C9
        LD      HL,$4018
        LD      A,(HL)
        OR      A
        JR      Z,L39C9
        DEC     (HL)
        LD      HL,L3961        ; point to MIXED data table for BOMBS
        LD      BC,$0540
        CALL    L3850
        SYSSUK  RANGED          ; UPI RANGED random number
        DB      $80             ; ... Cutoff = 128
        ;
        ADD     A,$14           ; write 20 to X lcation Hi
        LD      (IX+VBXH),A
        LD      (IX+VBYH),$16   ; write 22 to Y lcation Hi
        CALL    L2AA9           ; add $4F0D and PLAYER into HL for ??
        LD      A,(HL)
        SRL     A
        SRL     A
        CP      $20
        JR      NC,L39B1
        LD      A,$20
L39B1:  ADD     A,$10
        LD      (IX+VBDYL),A    ; write 16 or 32 for Delts Y Lo
        SYSSUK  RANGED          ; UPI RANGED random number
        DB      $02             ; ... Cutoff = 2
        ;
        INC     A               ; now a 1 or 2
        CP      $02
        JR      NZ,L39BF
        INC     A
L39BF:  LD      (IX+$1B),A
        SET     VBSACT,(IX+VBSTAT) ; set ACTive bit of BOMB VB STATus = 1
        CALL    L2A44           ; Move 7 bytes to RAM, then Send 8 SOUND bytes and Read 1 word for ??
L39C9:  CALL    L2AB8           ; add $4F05 and PLAYER into HL for ??
        LD      A,(HL)
        CP      $07
        JR      C,L39D9
        SYSSUK  RANGED          ; UPI RANGED random number
        DB      $18             ; ... Cutoff = 24
        ;
        ADD     A,$10
        LD      D,A
        JR      L39DB

L39D9:  LD      D,$05
L39DB:  LD      E,$06
        CALL    L20CB           ; do Set Counter Timer 6 to a 5
        JP      L396C           ; loop on Vectored C/T-6 routine
; end of Vectored C/T-6 routine

; does ??
L39E3:  PUSH    DE
        LD      A,($40C9+VBYH)  ; read PLAYER'S SHIP VB Y location Hi at $40D4
        SUB     (IX+VBYH)       ; minus Vector Block Y location Hi
        PUSH    AF
        JR      NZ,L39F2
        LD      DE,$0000
        JR      L39FB

L39F2:  JR      NC,L39FB
        LD      HL,$0000
        OR      A
        SBC     HL,DE
        EX      DE,HL
L39FB:  LD      L,(IX+VBDYL)      ; read VB Delta Y word
        LD      H,(IX+VBDYH)
        ADD     HL,DE
        BIT     7,H
        PUSH    AF
        CALL    NZ,L2035
        LD      A,($4011)
        LD      D,A
        LD      A,H
        CP      D
        JR      C,L3A13
        LD      H,D
        LD      L,$00
L3A13:  POP     AF
        CALL    NZ,L2035
        LD      (IX+VBDYL),L    ; write VB Delta Y word
        LD      (IX+VBDYH),H
        POP     AF
        POP     DE
        PUSH    AF
        LD      A,($40CF)
        SUB     (IX+VBXH)        ; minus VB X location Hi
        JR      NZ,L3A2D
        LD      DE,$0000
        JR      L3A36

L3A2D:  JR      NC,L3A36
        LD      HL,$0000
        OR      A
        SBC     HL,DE
        EX      DE,HL
L3A36:  LD      L,(IX+VBDXL)    ; read Delta X word
        LD      H,(IX+VBDXH)
        ADD     HL,DE
        BIT     7,H
        PUSH    AF
        CALL    NZ,L2035
        LD      A,($4013)
        LD      D,A
        LD      A,H
        CP      D
        JR      C,L3A4E
        LD      H,D
        LD      L,$00
L3A4E:  POP     AF
        CALL    NZ,L2035
        LD      (IX+VBDXL),L    ; write Delta X word
        LD      (IX+VBDXH),H
        POP     AF
        RET

; does continue ?? first, THEN to exit point for code stub
L3A5A:  LD      HL,$40CA
        BIT     7,(HL)
        JP      Z,L32A8         ; if ?? to exit point for code stub
        BIT     7,A
        JR      Z,L3A68
        NEG
L3A68:  CP      $10
        CALL    C,L2EF6         ; do Look for Empty Vector Block, then ??
        JP      L32A8           ; to exit point for code stub
; end of continue ?? first

; code stub for ODD FIGHTERS does ??
L3A70:  BIT     5,(IX+VBXCHK)   ; test UNKNOWN bit of VB X CHecK
        JP      NZ,L32A8        ; if ?? to exit point for code stub
        LD      A,($4F24)       ; ?? initalized to NUMber of PLaYers ??
        OR      A
        JR      Z,L3A84         ; if NONE left ?
        LD      HL,$401A
        INC     (HL)
        JP      L32A8           ; to exit point for code stub

L3A84:  LD      A,(IX+$1B)
        CP      $02
        JP      NZ,L32A8        ; if ?? to exit point for code stub
        DEC     (IX+$19)
        JP      NZ,L32A8        ; if ?? to exit point for code stub
        LD      A,($401E)
        LD      (IX+$19),A
        LD      DE,($401F)
        CALL    L39E3
        EX      AF,AF'
        CALL    L2A9F
        LD      A,(HL)
        CP      $07
        JP      C,L32A8         ; if ?? to exit point for code stub
        CALL    L2AA4
        LD      A,(HL)
        CP      $02
        JP      C,L32A8         ; if ?? to exit point for code stub
        EX      AF,AF'
        JP      L3A5A           ; to continue ?? first
; end of code stub for ODD FIGHTERS

; more MIXED data tables for ODD FIGHTERS
L3AB6:  DW      L2A78           ; 4-word RAM table of 17-byte VECTOR Blocks again
        DB      $04             ; 4 for ??
        DW      L3A70           ; is code stub for ODD FIGHTERS
        DW      L2613           ; Animation table for 3 TYPE-3 Fighters
        DW      L2A80           ; 4-bytes of Vector Limit Table again
        DW      L2731           ; Animation table for 4 Ship-Explosions again
        DB      $19             ; 25 POINTS for shooting !!

L3AC2:  DW      L2A78           ; 4-word RAM table of 17-byte VECTOR Blocks again
        DB      $04             ; 4 for ??
        DW      L3A70           ; is code stub for ODD FIGHTERS again
        DW      L25C2           ; Animation table for 2 TYPE-1 Fighters
        DW      L2A80           ; 4-bytes of Vector Limit Table again
        DW      L2731           ; Animation table for 4 Ship-Explosions again
        DB      $0A             ; 10 POINTS for shooting !!

; ?? 4-bytes of NARROWER Vector Limit Table for TYPE-5 Fighters ONLY !!
L3ACE:  DB      $0A             ; 10 for X Left
        DB      $95             ; 149 for X Right
        DB      $16             ; 22 for Y NARROWER Top
        DB      $43             ; 67 for Y Bottom

L3AD2:  DW      L2A78           ; 4-word RAM table of 17-byte VECTOR Blocks again
        DB      $04             ; 4 for ??
        DW      L3A70           ; is code stub for ODD FIGHTERS again
        DW      L28BA           ; Animation table for 3 TYPE-5 Fighters
        DW      L3ACE           ; NARROWER 4-bytes of Vector Limit Table
        DW      L2731           ; Animation table for 4 Ship-Explosions again
        DB      $32             ; 50 POINTS for shooting !!
; end of data tables for ODD FIGHTERS

; C/T-1 4-word RAM table for ODD FIGHTERS !! is on-screem ??
L3ADE:  DW      $41C1           ; VECTOR Block #1 in RAM
        DW      $41A2           ; VECTOR Block #2 in RAM
        DW      $4183           ; VECTOR Block #3 in RAM
        DW      $4164           ; VECTOR Block #4 in RAM

; Vectored C/T-1 routine does ??
L3AE6:  LD      A,($4F24)       ; ?? initalized to NUMber of PLaYers ??
        OR      A
        JR      NZ,L3B4E        ; if ANY left ?
        LD      A,($401A)
        OR      A
        JR      Z,L3B4E
        CALL    L2A9F           ; add $4F19 and PLAYER into HL for ??
        LD      A,(HL)          ; read 0 thru 3 ??
        LD      HL,L3ADE        ; point at 4-word RAM table for ODD FIGHTERS !!
        ADD     A,$01           ; plus 1
        CP      $04
        JR      C,L3B01
        LD      A,$04           ; maximum of 4
L3B01:  LD      B,A
        CALL    L389A           ; look in (RAM table) and if bit 7 = 0 then set IX to it
        OR      A
        JR      Z,L3B4E         ; if NOT Found flag
        LD      HL,$401A
        DEC     (HL)
        CALL    L2A9F           ; add $4F19 and PLAYER into HL for ??
        LD      A,(HL)
        CP      $03
        JR      NC,L3B19
        LD      HL,L3AC2        ; point to MIXED data table for TYPE-1 Fighter
        JR      L3B34

L3B19:  SYSSUK  RANGED                  ;  UPI RANGED random number
        DB      $03                     ;  ... Cutoff = 3
        ;
        OR      A
        JR      NZ,L3B24
        LD      HL,L3AB6        ; point to MIXED data table for TYPE-3 Fighter
        JR      L3B34

L3B24:  CALL    L2A9F           ; add $4F19 and PLAYER into HL for ??
        LD      A,(HL)
        CP      $05
        JR      NC,L3B31
        LD      HL,L3AC2        ; point to MIXED data table for TYPE-1 Fighter again ??
        JR      L3B34

L3B31:  LD      HL,L3AD2        ; point to MIXED data table for TYPE-5 Fighter
L3B34:  LD      BC,$8380
        CALL    L3850
        LD      A,$95
        LD      (IX+VBXH),A     ; write 149 for X location Hi
        SYSSUK  RANGED          ; UPI RANGED random number
        DB      $20             ; ... Cutoff = 32
        ;
        LD      (IX+VBDYL),A    ; write 0 to 31 for Delta Y Hi
        ADD     A,$18
        LD      (IX+VBYH),A     ; write 24 to 55 for Y location Hi
        SET     VBSACT,(IX+VBSTAT) ; set ACTive bit of TYPE-5 Fighter STATus = 1
L3B4E:  LD      DE,$0401
        CALL    L20CB           ; do Set Counter Timer 1 to a 4
        JP      L3AE6           ; loop on Vectored C/T-1 routine
; end of Vectored C/T-1 routine

; code stub for EVEN FIGHTERS does ??
L3B57:  BIT     5,(IX+VBXCHK)   ; test UNKNOWN bit of VB X CHecK
        JP      NZ,L32A8        ; if ?? to exit point for code stub
        LD      A,($4F24)       ; ?? initalized to NUMber of PLaYers ??
        OR      A
        JR      Z,L3B6B         ; if NONE left
        LD      HL,$4019
        INC     (HL)
        JP      L32A8           ; to exit point for code stub

L3B6B:  LD      A,(IX+$1B)
        CP      $02
        JP      NZ,L32A8        ; if ?? to exit point for code stub
        DEC     (IX+$19)
        JP      NZ,L32A8        ; if ?? to exit point for code stub
        LD      A,($401B)
        LD      (IX+$19),A
        LD      DE,($401C)
        CALL    L39E3
        EX      AF,AF'
        CALL    L2AA4           ; add $4F11 and PLAYER into HL for ??
        LD      A,(HL)
        CP      $03
        JP      C,L32A8         ; if ?? to exit point for code stub
        EX      AF,AF'
        JP      L3A5A           ; to continue ?? first
; end of code stub for EVEN FIGHTERS

; last of MIXED data tables for EVEN FIGHTERS
L3B94:  DW      L2A78           ; 4-word RAM table of 17-byte VECTOR Blocks again
        DB      $04             ; 4 for ??
        DW      L3B57           ; is code stub for EVEN FIGHTERS
        DW      L267C           ; Animation table for 3 TYPE-4 Fighters
        DW      L2A80           ; 4-bytes of Vector Limit Table
        DW      L2731           ; Animation table for 4 Ship-Explosions
        DB      $19             ; 25 POINTS for shooting !!

L3BA0:  DW      L2A78           ; 4-word RAM table of 17-byte VECTOR Blocks again
        DB      $04             ; 4 for ??
        DW      L3B57           ; is code stub for EVEN FIGHTERS again
        DW      L25DD           ; Animation table for 1 TYPE-2 Fighter
        DW      L2A80           ; 4-bytes of Vector Limit Table again
        DW      L2731           ; Animation table for 4 Ship-Explosions again
        DB      $32             ; 50 POINTS for shooting !!
; end of data tables for EVEN FIGHTERS

; C/T-2 3-word RAM table for EVEN FIGHTERS !! is onscreen ??
L3BAC:  DW      $4145           ; VECTOR Block #1 in RAM
        DW      $4126           ; VECTOR Block #2 in RAM
        DW      $4107           ; VECTOR Block #3 in RAM

; Vectored C/T-2 routine does ??
L3BB2:  LD      A,($4F24)       ; ?? initalized to NUMber of PLaYers ??
        OR      A
        JR      NZ,L3C01        ; if ANY left ?
        LD      A,($4019)
        OR      A
        JR      Z,L3C01
        CALL    L2A9F           ; add $4F19 and PLAYER into HL for ??
        LD      A,(HL)          ; read 0 thru 2 ??
        INC     A               ; plus 1
        LD      HL,L3BAC        ; point at 3-word RAM table for EVEN FIGHTERS !!
        CP      $03             ; maximum of 3
        JR      C,L3BCC
        LD      A,$03
L3BCC:  LD      B,A
        CALL    L389A           ; look in (RAM table) and if bit 7 = 0 then set IX to it
        OR      A
        JR      Z,L3C01         ; if NOT Found flag
        LD      HL,$4019
        DEC     (HL)
        CALL    L2A9F           ; add $4F19 and PLAYER into HL for ??
        LD      A,(HL)
        CP      $03
        JR      NC,L3BE4
        LD      HL,L3B94        ; point to MIXED data table for TYPE-4 Fighter
        JR      L3BE7

L3BE4:  LD      HL,L3BA0        ; point to MIXED data table for TYPE-2 Fighter
L3BE7:  LD      BC,$8380
        CALL    L3850
        LD      A,$95
        LD      (IX+VBXH),A     ; write 149 for X location Hi
        SYSSUK  RANGED          ; UPI RANGED random number
        DB      $20             ; ... Cutoff = 32
        ;
        LD      (IX+VBDYL),A    ; write 0 to 31 for Delta Y Hi
        ADD     A,$18
        LD      (IX+VBYH),A     ; write 24 to 55 for Y location Hi
        SET     VBSACT,(IX+VBSTAT) ; set ACTive bit of TYPE-2 Fighter STATus = 1
L3C01:  LD      DE,$0502
        CALL    L20CB           ; do Set Counter Timer 2 to a 5
        JP      L3BB2           ; loop on Vectored C/T-2 routine
; end of Vectored C/T-2 routine

; ??
L3C0A:  CALL    L2AA9           ; add $4F0D and PLAYER into HL for ??
        LD      E,(HL)
        LD      D,$00
        SLA     E
        JR      NC,L3C17
        LD      DE,$0100
L3C17:  LD      ($401F),DE
        LD      A,(HL)
        LD      ($401C),A
        SRL     A
        SRL     A
        SRL     A
        NEG
        ADD     A,$22
        LD      ($401B),A
        ADD     A,$03
        LD      ($401E),A
        LD      A,(HL)
        SRL     A
        NEG
        ADD     A,$F0
        CP      $A0
        JR      NC,L3C3E
        LD      A,$A0
L3C3E:  LD      ($4F22),A
        LD      BC,$0202
        LD      DE,$0202
        LD      A,(HL)
        CP      $81
        JR      NC,L3C51
        LD      DE,$0101
        JR      L3C5B

L3C51:  CP      $41
        JR      NC,L3C5B
        LD      BC,$0101
        LD      DE,$0101
L3C5B:  LD      ($4013),BC
        LD      ($4011),DE
        RET

; does Clear ALL seventeen VECTOR Blocks
L3C64:  SYSSUK  FILL            ; UPI FILL memory with data
        DW      $4021           ; ... Memory Address = 16417 for base Vector
        DW      $01BF           ; ... Byte Count = 447 to 16863
        DB      $00             ; ... Data = 0
        ;
        RET

; Vectored C/T-4 routine does ??
L3C6C:  LD      A,($4F24)       ; ?? initalized to NUMber of PLaYers ??
        OR      A
        JP      NZ,L3C8E        ; if ANY left ?
        CALL    L2AB8           ; add $4F05 and PLAYER into HL for ??
        LD      A,(HL)
        CALL    L2ABE           ; add $4EFD and PLAYER into HL for ??
        ADD     A,(HL)
        OR      A
        JP      NZ,L3C8B
        INC     A
        LD      ($4F24),A       ; ?? set ?? to 1 PLAYER for ??
        CALL    L2ACA           ; add $4F01 and PLAYER into HL for ??
        SET     7,(HL)
        CALL    L210E           ; clear ?? address, then Zero $4F9E ?? then ?? and on to ($4F9F)
L3C8B:  JP      L3E63

L3C8E:  LD      A,($4F25)       ; ?? for ??
        OR      A
        JP      NZ,L3E63
        CALL    L2081           ; do Clear bytes $4FB0 and $4FB1
        CALL    L3C64           ; do Clear ALL seventeen VECTOR Blocks
        CALL    L2B0B           ; Clear PLAYFIELD
        CALL    L208E           ; do Clear byte $4FB1 and check $4FB0
        CALL    L2ACA           ; add $4F01 and PLAYER into HL for ??
        BIT     7,(HL)
        JP      Z,L3CEE
        LD      B,$00
        CALL    L2AC4           ; add $4EF9 and PLAYER into HL for ??
        LD      A,(HL)
        SRA     A
        LD      B,A
        CALL    L2A9F           ; add $4F19 and PLAYER into HL for ??
        LD      A,(HL)
L3CB6:  SUB     $03
        JP      C,L3CD2
        JR      NZ,L3CB6
        CALL    L2AAE           ; add $4F09 and PLAYER into HL for ??
        LD      A,(HL)
        CP      $09
        JP      Z,L3CD1
        PUSH    BC
        CALL    L2B01           ; display Number of CURRENT Player's SHIPS remaining
        POP     BC
        CALL    L2C9B           ; display "PLAYER 1-4", "BONUS", a SHIP and any STAR(s)
        JP      L3CE8

L3CD1:  INC     B
L3CD2:  LD      A,B
        OR      A
        JR      Z,L3CEE
        LD      A,($4F1E)
        OR      A
        JP      Z,L3CE5
        CALL    L2AAE           ; add $4F09 and PLAYER into HL for ??
        LD      A,(HL)
        DEC     A
        JP      Z,L3CEE
L3CE5:  CALL    L2CC8           ; display "PLAYER 1-4", "BONUS" and 1, 2 or 3 STAR(s) then SCORE, STARS and FIGHTERS
L3CE8:  LD      DE,$0A04
        CALL    L20CB           ; do Set Counter Timer 4 to a 10
L3CEE:  CALL    L2B01           ; display Number of CURRENT Player's SHIPS remaining
        LD      A,($4F1E)
        OR      A
        JP      Z,L3D5C
        CALL    L2AAE           ; add $4F09 and PLAYER into HL for ??
        DEC     (HL)
        PUSH    AF
        CALL    L2B01           ; display Number of CURRENT Player's SHIPS remaining
        POP     AF
        JP      NZ,L3D3A
        CALL    L2ACA           ; add $4F01 and PLAYER into HL for ??
        INC     (HL)
        LD      HL,$4016        ; ?? initalized to NUMber of PLaYers ??
        DEC     (HL)
        JP      NZ,L3D31        ; anyone left ?
        CALL    L2D0F           ; display "GAME OVER" (for EVERYBODY !!)
        CALL    L2D4F
        LD      DE,$0A04
        CALL    L20CB           ; do Set Counter Timer 4 to a 10
L3D1B:  LD      C,$10
        IN      A,(C)
        INC     C
        IN      D,(C)
        INC     C
        IN      E,(C)
        INC     C
        IN      B,(C)
        OR      B
        OR      E
        OR      D
        JP      Z,L3D1B         ; loop until ANY control moved
        JP      $0000           ; Reset System

L3D31:  CALL    L2D02           ; display "PLAYER 1 through 4" then "GAME OVER"
        LD      DE,$0A04
        CALL    L20CB           ; do Set Counter Timer 4 to a 10
L3D3A:  LD      HL,$4F1F        ; point at CURRENT Player
        LD      A,(NUMPLY)      ; read $4FF3
        INC     (HL)            ; ready for NEXT Player
        CP      (HL)
        JP      NZ,L3D47        ; unless too many, then ...
        LD      (HL),$00        ; clear CURRENT Player
L3D47:  CALL    L2ACA           ; add $4F01 and PLAYER into HL for ??
        LD      A,(HL)
        RES     7,A
        OR      A
        JP      NZ,L3D3A
        LD      A,(NUMPLY)      ; read $4FF3
        CP      $01
        JP      Z,L3D5C
        LD      ($4015),A       ; ?? DO NOT set ?? to 1 PLAYER for ??
L3D5C:  LD      A,$92           ; 146 ScanLINES for 73 PIXEL lines out ...
        OUT     (VERBL),A       ; ... port $0A for VERtical Blanking Line
        LD      ($4F1D),A       ; 146 ?? for non-zero Color BAR blanking
        CALL    L2081           ; do Clear bytes $4FB0 and $4FB1
        CALL    L3C64           ; do Clear ALL seventeen VECTOR Blocks
        CALL    L2B0B           ; Clear PLAYFIELD
        CALL    L2B13           ; display SCORE, RADAR and CONTROL PANEL boxes
        CALL    L2B7E           ; display SCORE, STARS and FIGHTERS as BCD numbers
        CALL    L2B01           ; display Number of CURRENT Player's SHIPS remaining
        CALL    L208E           ; do Clear byte $4FB1 and check $4FB0
        LD      A,$B6           ; 182 ScanLINES for 91 PIXEL lines out ...
        OUT     (VERBL),A       ; ... port $0A for VERtical Blanking Line
        XOR     A
        LD      ($4F1D),A       ; 0 for NO Color BAR blanking
        LD      A,$1C           ; 28 bytes (out of 40) out ...
        OUT     (HORCB),A       ; ... port $09 for HORizontal Color Boundary
        LD      A,($4015)       ; ?? any PLAYERS left ?
        OR      A
        CALL    NZ,L2CF0        ; if ANY display "PLAYER 1 through 4", then "GOOD LUCK"
        CALL    L2ACA           ; add $4F01 and PLAYER into HL for ??
        BIT     7,(HL)
        JP      Z,L3DF2         ; !! skip a bunch of stuff if NOT entering a NEW Sector
        RES     7,(HL)
        CALL    L2A9F           ; add $4F19 and PLAYER into HL for ??
        INC     (HL)
        LD      A,(HL)
        LD      D,A
        LD      B,A
        PUSH    BC
        XOR     A
        LD      C,$05
L3DA0:  ADD     A,C
        DJNZ    L3DA0
        ADD     A,$05
        CP      $28
        JP      C,L3DAC
        LD      A,$28
L3DAC:  CALL    L2AB8           ; add $4F05 and PLAYER into HL for ??
        LD      (HL),A
        CALL    L2AB3           ; add $4F15 and PLAYER into HL for ??
        LD      A,(HL)
        LD      ($4017),A
        LD      (HL),A
        CALL    L2ABE           ; add $4EFD and PLAYER into HL for ??
        LD      (HL),$04
        CALL    L2AC4           ; add $4EF9 and PLAYER into HL for ??
        LD      (HL),$00
        CALL    L2AA4           ; add $4F11 and PLAYER into HL for ??
        LD      B,(HL)
        XOR     A
        LD      C,$18
L3DC9:  ADD     A,C
        DJNZ    L3DC9
        CALL    L2AA9           ; add $4F0D and PLAYER into HL for ??
        LD      (HL),A
        POP     BC
        OR      A
        JP      Z,L3DE2
        XOR     A
        LD      C,$05
L3DD8:  ADD     A,C
        DJNZ    L3DD8
        ADD     A,(HL)
        JP      NC,L3DE1
        LD      A,$F0
L3DE1:  LD      (HL),A
L3DE2:  CALL    L2B7E           ; display SCORE, STARS and FIGHTERS as BCD numbers
        LD      A,($4015)       ; ?? any PLAYERS left ?
        OR      A
        LD      DE,$0A04
        CALL    NZ,L20CB        ; if ANY Set Counter Timer 4 to a 10
        CALL    L2C49           ; display "ENTERING SECTOR " and SECTOR Number
; skip to here if NOT a NEW Sector, after displaying "PLAYER 1 thru 4" and "GOOD LUCK"
L3DF2:  CALL    L2D39           ; display All Player's NUMBERs (highlight one) and INFOs
        CALL    L2B7E           ; display SCORE, STARS and FIGHTERS as BCD numbers
        LD      DE,$0204
        CALL    L20CB           ; do Set Counter Timer 4 to a 2
        CALL    L2AD0           ; do Set C for Current INPUT Port
L3E01:  IN      A,(C)
        BIT     4,A
        JP      Z,L3E01         ; loop until Trigger pulled
        CALL    L2B0B           ; Clear PLAYFIELD
        CALL    L3C0A
        CALL    L2AB8           ; add $4F05 and PLAYER into HL for ??
        LD      A,(HL)
        SRA     A
        LD      ($4019),A
        JP      NC,L3E1B
        INC     A
L3E1B:  LD      ($401A),A
        CALL    L2ABE           ; add $4EFD and PLAYER into HL for ??
        LD      A,(HL)
        LD      ($4018),A
        CALL    L2AB3           ; add $4F15 and PLAYER into HL for ??
        LD      A,(HL)
        LD      ($4017),A
        SYSSUK  MOVE            ; UPI MOVE block transfer to reset Limit Table
        DW      $4F2E           ; ... Destination Address = 20270 in RAM !!
        DW      $0004           ; ... Byte Count = 4
        DW      L2A84           ; ... Source Address = 10884 for Player's Ship
        ;
        CALL    L2994           ; send 8 SOUND bytes routine #2 ??
        LD      A,$0F
        LD      ($4F28),A
        LD      ($4F29),A
        LD      HL,$FFFF
        LD      ($4F26),HL
        XOR     A               ; write 0 multiple places
        LD      ($4F24),A       ; ?? set ?? to 0 PLAYERS for ??
        LD      ($4F23),A       ; 0 for ??
        LD      ($4F1E),A       ; 0 for ??
        LD      ($4015),A       ; ?? set ?? to 0 PLAYERS for ??
        LD      IX,$40C9        ; point to Player's Ship VECTOR Block !!
        LD      HL,L3919        ; point at Player's Ship 12-byte data table
        LD      BC,$91C0        ; ?? and set VBYCHK VBCLMT
        CALL    L3850
        SET     VBSACT,(IX+VBSTAT) ; set Player's Ship STatus byte ACTive
L3E63:  LD      DE,$0404
        CALL    L20CB           ; do Set Counter Timer 4 to a 4
        JP      L3C6C           ; loop on Vectored C/T-4 routine
; end of Vectored C/T-4 routine

; does CONTINUE to initialize Interrupt stuff then initalize User UPI Routine
L3E6C:  CALL    L23C1           ; initialize some Interrupt stuff then run INITIAL Interrupt Routine
        JP      L2E4D           ; to initalize User UPI Routine, even number $80 (or $81 for SUCK)

; Start "Cosmic Raiders"
L3E72:  DI
        LD      SP,$4FC0        ; NOT leave room for C/T 0 through 7 VECTORS in RAM
        LD      A,$F0
        OUT     ($CC),A         ; !! port 204 for MYSTIC register = 240 for ??
        CALL    L2019           ; Clear Screen, SETOUT, set MENU Colors and ACTINT
;  then ... SELECT GAME Menu
;  Note: This routine expects the "SELECT GAME" string to be at
;  location $0DF3.  This is accurate for the majority of Bally Arcade/
;  Astrocade on-board ROMs, but NOT the "3164 ROM."  At this location in
;  the 3164 ROM are the last three letters of "SCRIBBLING" (ING followed
;  by $00 to end the string).  When COSMIC RAIDERS is run on a Bally Home
;  Library Computer with this early "3164 ROM," instead of displaying
;  "SELECT GAME" at the top of the menu, only "ING" is displayed.
; L3E7D:
        LD      DE,$0DF3        ; ... Address of "SELECT GAME" in "3159 ROM"
        LD      HL,L3E85        ; ... Address of Next Menu Node
        SYSTEM  MENU            ; UPI display a MENU

L3E85:  DW      MENUST          ; ... Next Menu Node (in SYStem DOPE Vector)
        DW      L2BBC           ; ... Choice 1 Text is "COSMIC RAIDER"
        DW      L3E8B           ; ... Start of "COSMIC RAIDERS"

L3E8B:  SYSSUK  GETPAR          ; UPI GET game PARameter from user
        DW      NOPLAY          ; ... Prompt "# OF PLAYERS"
        DB      $01             ; ... Digits = 1
        DW      NUMPLY          ; ... Parameter Address = 20467
        ;
        DI
        LD      A,(NUMPLY)      ; read $4FF3
        OR      A               ; Set Zero flag if NUMPLY=0
        JP      Z,L3E8B         ; If # of Players is 0, then ask again
        CP      $05             ; Subtract 5 from NUMPLY
        JP      NC,L3E8B        ; If # of Players > 4, then ask again
        SYSSUK  GETPAR          ; UPI GET game PARameter from user
        DW      L2BFC           ; ... Prompt Address "# OF SHIPS"
        DB      $01             ; ... Digits = 1
        DW      SHIPS           ; ... Parameter Address = 20468
        ;
        DI
        LD      A,(SHIPS)       ; read $4FF4
        OR      A               ; Set Zero flag if SHIPS=0
        JP      Z,L3E8B         ; If # of Ships is 0, then ask # of Players (again)
        LD      DE,L2C08        ; String Address "PLAYER 1"
        LD      BC,L2BE5        ; String Address "INTENSITY      0 TO 9"
        LD      A,$01           ; Get 1 digit
        LD      HL,INTEN1       ; Storage for Player 1 Intensity Level
        SYSTEM  GETPAR          ; UPI GET game PARameter from user
        ;
        LD      A,(NUMPLY)      ; read $4FF3
        DEC     A               ; More than one player?
        JP      Z,L3EF9         ; If no more players, then stop asking
        LD      DE,L2C12        ; String Address "PLAYER 2"
        LD      BC,L2BE5        ; String Address "INTENSITY      0 TO 9"
        LD      A,$01           ; Get 1 digit
        LD      HL,INTEN2       ; Storage for Player 2 Intensity Level
        SYSTEM  GETPAR          ; UPI GET game PARameter from user
        ;
        LD      A,(NUMPLY)      ; read $4FF3
        CP      $02             ; More than two players?
        JP      Z,L3EF9         ; If no more players, then stop asking
        LD      DE,L2C1C        ; String Address "PLAYER 3"
        LD      BC,L2BE5        ; String Address "INTENSITY      0 TO 9"
        LD      A,$01           ; Get 1 digit
        LD      HL,INTEN3       ; Storage for Player 3 Intensity Level
        SYSTEM  GETPAR          ; UPI GET game PARameter from user
        ;
        LD      A,(NUMPLY)      ; read $4FF3
        CP      $03             ; More than three players?
        JP      Z,L3EF9         ; If no more players, then stop asking
        LD      DE,L2C26        ; String Address "PLAYER 4"
        LD      BC,L2BE5        ; String Address "INTENSITY      0 TO 9"
        LD      A,$01           ; Get 1 digit
        LD      HL,INTEN4       ; Storage for Player 4 Intensity Level
        SYSTEM  GETPAR          ; UPI GET game PARameter from user
        ;
L3EF9:  LD      A,$92           ; 146 ScanLINES for 73 PIXEL lines out ...
        OUT     (VERBL),A       ; ... port $0A for VERtical Blanking Line
        XOR     A               ; Zero-out Accumulator
        OUT     (COL0L),A       ; write COLor 0 Left (Black)
        SYSSUK  FILL            ; UPI FILL memory with data to Clear top 80 Screen lines
        DW      NORMEM          ; ... Memory Address = 16384
        DW      $0F00           ; ... Byte Count = 3840
        DB      $00             ; ... Data = 0
        ;
        LD      SP,$4EF4        ; at scanLINE 95.5 * BYTEPL
        LD      HL,(INTEN1)     ; store $4F11 and $4F12 ...
        PUSH    HL
        LD      DE,(INTEN3)     ; then store $4F13 and $4F14
        PUSH    DE
        SYSSUK  FILL            ; UPI FILL memory with data to Clear $4EF4 through $4FC4 Below Screen
        DW      $4EF4           ; ... Memory Address = 20212
        DW      $00D1           ; ... Byte Count = 209
        DB      $00             ; ... Data = 0 (INTEN1 through INTEN4 got set to 0 !!)
        ;
        CALL    L3892           ; Fill 16 bytes of RAM at $4011-$4020 with 0's (ABOVE the PLAYFIELD !!)
        POP     DE
        LD      (INTEN3),DE     ; restore $4F11 and $4F12 ...
        POP     HL
        LD      (INTEN1),HL     ; then restore $4F13 and $4F14
        LD      A,$01
        LD      ($4F1D),A       ; 1 for non-zero Color BAR blanking
        LD      HL,L232C        ; point at INITIAL Interrupt Routine (scanLINEs 112 to 147)
        LD      ($4F86),HL
        LD      A,$70           ; pre-set INITIAL Interrupt scanline to 112 (why ??)
        LD      ($4F7B),A
        LD      A,$93           ; pre-set DIRT Interrupt scanline to 147 (never changes ??)
        LD      ($4F7D),A
        LD      A,$F0           ; pre-set TOP of Screen Interrupt scanline to 240 (offscreen)
        LD      ($4F7C),A
        LD      A,$3C           ; pre-set ?? to 60 ??
        LD      ($4F7A),A
        LD      HL,(L227C)      ; load first RAM address + 4 into (HL) and (HL + 2) ??
        CALL    L21DE
        LD      HL,(L2280)      ; load second RAM address + 4 into (HL) and (HL + 2) ??
        CALL    L21DE
        LD      HL,L3783        ; point at DIRT Interrupt Routine (scanLINEs 147 to 159)
        LD      ($4F8A),HL
        LD      HL,L37A5        ; point at CONTROL Panel Interrupt Routine (159 to 179)
        LD      ($4F84),HL
        LD      HL,L348F        ; point at BOTTOM of Screen Interrupt Routine (179 to 240)
        LD      ($4F82),HL
        LD      HL,L37D1        ; point at TOP of Screen Interrupt Routine (240 to 24)
        LD      ($4F88),HL
        LD      HL,L3800        ; point at PLAYFIELD Interrupt Routine (24 to 108)
        LD      ($4F80),HL
        LD      HL,L23CD        ; point at STARTING ?? Interrupt Routine (108 to 112)
        LD      ($4F7E),HL
        LD      A,$02           ; pre-set $4F15 through $4F18 ?? to 2 (for ??)
        LD      HL,$4F15
        LD      (HL),A
        INC     HL
        LD      (HL),A
        INC     HL
        LD      (HL),A
        INC     HL
        LD      (HL),A
        LD      A,(SHIPS)       ; read $4FF4
        LD      HL,$4F09        ; pre-set $4F09 through $4F0C ?? to SHIPS
        LD      (HL),A
        INC     HL
        LD      (HL),A
        INC     HL
        LD      (HL),A
        INC     HL
        LD      (HL),A
        LD      A,$80
        LD      HL,$4F01        ; pre-set $4F01 through $4F04 ?? to 128 (for ??)
        LD      (HL),A
        INC     HL
        LD      (HL),A
        INC     HL
        LD      (HL),A
        INC     HL
        LD      (HL),A
        LD      B,$28           ; loop for 40
L3F9C:  PUSH    BC
        CALL    L3394           ; do Display Column of DIRT
        POP     BC
        DJNZ    L3F9C
        LD      A,(NUMPLY)      ; read $4FF3
        LD      ($4016),A       ; write multiple places ...
        LD      ($4F2A),A
        LD      ($4F2B),A
        LD      ($4EF4),A       ; also is Top of System Stack
        LD      ($4F24),A       ; also 0 or 1 a lot ??
        LD      ($4015),A       ;
        CALL    L210E           ; clear ?? address, then Zero $4F9E ?? then ?? and on to ($4F9F)
        LD      A,$01
        LD      ($4FC2),A       ; write 1 to ?? for ??
; C/T-0 not Vectored ?? at $4FB2 ?? so preset Vectors for others
        LD      HL,L3AE6
        LD      ($4FB4),HL      ; preset C/T-1 Vector to ??
        LD      HL,L3BB2
        LD      ($4FB6),HL      ; preset C/T-2 Vector to ??
        LD      HL,L38D1
        LD      ($4FB8),HL      ; preset C/T-3 Vector to ??
        LD      HL,L3C6C
        LD      ($4FBA),HL      ; preset C/T-4 Vector to ??
        LD      HL,L2B9E
        LD      ($4FBC),HL      ; preset C/T-5 Vector to ??
        LD      HL,L396C
        LD      ($4FBE),HL      ; preset C/T-6 Vector to ??
; C/T-7 not Vectored ?? at $4FC0 ?? so set other Counter/Timers
        LD      A,$01
        LD      (CT4),A         ; set $4FD9 to a 1
        LD      A,$04
        LD      (CT1),A         ; set $4FD6 to a 4
        LD      A,$08
        LD      (CT2),A         ; set $4FD7 to an 8
        LD      (CT3),A         ; set $4FD8 to an 8
        LD      (CT5),A         ; set $4FDA to an 8
        LD      (CT6),A         ; set $4FDB to an 8
        JP      L3E6C           ; to CONTINUE above

; one byte left over !!
        DB      $FF

END
;

Instructions from Astrocade Manual
----------------------------------

Astrocade, The Professional Videocade (TM), Cartridge

COSMIC RAIDERS  2019

In deep space lies the alien sector Larkin.  You are there on a mission to
obtain energy sources that have been seized by the evil Larkins.  Radar and a
superior guidance system help you avoid attacking fighters and Kamikaze ships.
The energy stars are near the Larkin command ship: you must retrieve them
before you can leave the enemy sector.

Copyright (C)1982 Astrocade, Inc.  All Rights Reserved

Designed & Programmed by Bob Ogdon
Audio by Scot L. Norris
Graphics by Julie Malan & Lisa Natting
Developed by Action Graphics


LOADING INSTRUCTIONS

1.  Turn on your Astrocade and TV set, then select channel 3 or 4.

2.  Connect the hand controls by inserting control #1 into the first jack on
    the back left side (as you face the front of the Astrocade).  From left
    to right, the jacks connect to players 1, 2, 4 and 3.

3.  Insert the game cartridge, label side up, into the cartridge slot.  Press
    it down firmly to lock it into position.

4.  Press the RESET button and the menu of games will be displayed.


COSMIC RAIDERS (1-4 players)

An evil force, LARKIN, is attacking your base planet.  In every sector you
travel through, four bombs are dropped with a slew of fighters to ensure the
bombs will reach your planet.  By destroying the bombs, you can earn bonus
energy stars.  Energy stars are floating above the planet for your strategic
use.  By flying through one, you are energized with an invincible energy
shield to help you wipe out the enemy.


STARTING THE GAME

Choose Cosmic Raiders by pressing 1 on the keypad or by using remote game
selection (pull the trigger on hand control #1, turn the knob until 1 appears
on the screen, then pull the trigger again).

Enter the number of players (1, 2, 3 or 4).  Each player selects his level of
difficulty (0-9).  Level 0 is extremely easy and is the only level that does
not get harder as you play.

Choose the number of ships you have at your command (1-9).  The number will
be the same for each player.


PLAYING THE GAME

The hand control functions for Cosmic Raiders are:

Trigger     Fires your missiles
Knob        Has no function
Joystick    Controls your acceleration and movement up and down,
            left to right.

The object of the game is to reach the highest score by shooting down as many
enemy fighters as possible and destroying bombs for bonus energy stars.
Every 2 bombs destroyed in a sector gives you a bonus energy star.  Radar is
used to track in front of and behind your view.  Enemy fighters are shown in
white and bombs are shown in red.  Your ships and the energy stars are shown
in black.  "F" on the control panel tells you how many enemy fighters you
must destroy to complete a sector.  "S" on the control panel tells you how
many energy stars you have available to you.  The number farthest to the right
on the control panel tells you how many ships you have left.

You have completed a sector when all enemy fighters are destroyed.  When there
is more than 1 player, the next player will have his turn when one of your
ships is shot down.  Each player starts with 2 energy stars and whatever
number of ships have been selected.


SCORING

There are different types of enemy fighters.  Some of them fire missiles at
you, others are kamikaze ships and will try to crash into you.  The type of
fighter you hit determines the number of points scored.

Fighter    Fighter     Fighter     Fighter     Fighter     Energy Star

Type 1     (Type 2     (Type 3     (Type 4     (Type 5       (Energy
 Pic)        Pic)        Pic)        Pic)        Pic)        Star pic)

10 Points  25 Points   25 Points   50 Points   50 Points    200 Points

The number of bombs destroyed within a sector determines your super
bonus points:

                                               Bomb
1st bomb    100 points
2nd bomb    250 points (+ Bonus Energy Star)   (Bomb
3rd bomb    500 points                          pic)
4th bomb  1,000 points (+ Bonus Energy Star)

Energy stars can be saved up as you go from sector to sector.  At the end of
each sector, you receive an additional energy star for every 2 bombs you have
destroyed.  After every 3 sectors completed, you receive a bonus ship.  If
you have your maximum of 9 ships, you receive a bonus energy star instead.
Every time you use an energy star you receive 200 extra points.


STRATEGIES FOR WINNING

Watch your radar for bombs and destroy them before they hit the ground to
earn high points and energy stars.

Try to succeed on as many levels as you can without using up any of your
energy stars.  Save them for meeting the tougher challenge of the higher
levels.  And remember -- an energy star only protects you for a limited
period of time.  Try to use them when you can attack several fighters at
once.  Don't forget: some of the enemy ships are kamikaze attackers.  They
won't shoot but they move fast and will try to crash into you.  Watch your
tail - fighters will sometimes shoot at you from behind.


PLAYING AGAIN

To play Cosmic Raiders again, any player may pull his trigger, or press the
RESET button and follow the instructions for starting the game.
